// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TmpfsOptions TmpfsOptions defines options specific to mounts of type "tmpfs".
//
// swagger:model TmpfsOptions
type TmpfsOptions struct {

	// mode
	Mode FileMode `json:"Mode,omitempty"`

	// Size sets the size of the tmpfs, in bytes.
	//
	// This will be converted to an operating system specific value
	// depending on the host. For example, on linux, it will be converted to
	// use a 'k', 'm' or 'g' syntax. BSD, though not widely supported with
	// docker, uses a straight byte value.
	//
	// Percentages are not supported.
	SizeBytes int64 `json:"SizeBytes,omitempty"`
}

// Validate validates this tmpfs options
func (m *TmpfsOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TmpfsOptions) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	if err := m.Mode.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Mode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Mode")
		}
		return err
	}

	return nil
}

// ContextValidate validate this tmpfs options based on the context it is used
func (m *TmpfsOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TmpfsOptions) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Mode.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Mode")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Mode")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TmpfsOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TmpfsOptions) UnmarshalBinary(b []byte) error {
	var res TmpfsOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
