package images

const (
	DefaultImageRegistry      string = "registry.redhat.io/service-interconnect"
	RouterImageName           string = "skupper-router-rhel9:3.4.1"
	ControllerImageName       string = "skupper-controller-rhel9:2.1.2"
	KubeAdaptorImageName      string = "skupper-kube-adaptor-rhel9:2.1.2"
	NetworkObserverImageName  string = "skupper-network-observer-rhel9:2.1.2"
	CliImageName              string = "skupper-cli-rhel9:2.1.2"
	SystemControllerImageName string = "skupper-system-controller-rhel9:2.1.2"

	PrometheusImageRegistry   string = "registry.redhat.io/openshift4"
	PrometheusServerImageName string = "ose-prometheus-rhel9:v4.16.0"
	OauthProxyImageRegistry   string = "registry.redhat.io/openshift4"
	OauthProxyImageName       string = "ose-oauth-proxy-rhel9:v4.16.0"
)

var (
	KubeComponents       = []string{"router", "controller", "network-observer", "cli", "prometheus", "origin-oauth-proxy"}
	NonKubeComponents    = []string{"router", "network-observer", "cli", "system-controller", "prometheus", "origin-oauth-proxy"}
	DefaultComponents    = []string{"router", "prometheus", "origin-oauth-proxy"}
	DevelopmentImageTags = []string{"main", "v2-dev"}
)
