/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSites implements SiteInterface
type FakeSites struct {
	Fake *FakeSkupperV2alpha1
	ns   string
}

var sitesResource = v2alpha1.SchemeGroupVersion.WithResource("sites")

var sitesKind = v2alpha1.SchemeGroupVersion.WithKind("Site")

// Get takes name of the site, and returns the corresponding site object, and an error if there is any.
func (c *FakeSites) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.Site, err error) {
	emptyResult := &v2alpha1.Site{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(sitesResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.Site), err
}

// List takes label and field selectors, and returns the list of Sites that match those selectors.
func (c *FakeSites) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.SiteList, err error) {
	emptyResult := &v2alpha1.SiteList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(sitesResource, sitesKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2alpha1.SiteList{ListMeta: obj.(*v2alpha1.SiteList).ListMeta}
	for _, item := range obj.(*v2alpha1.SiteList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested sites.
func (c *FakeSites) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(sitesResource, c.ns, opts))

}

// Create takes the representation of a site and creates it.  Returns the server's representation of the site, and an error, if there is any.
func (c *FakeSites) Create(ctx context.Context, site *v2alpha1.Site, opts v1.CreateOptions) (result *v2alpha1.Site, err error) {
	emptyResult := &v2alpha1.Site{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(sitesResource, c.ns, site, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.Site), err
}

// Update takes the representation of a site and updates it. Returns the server's representation of the site, and an error, if there is any.
func (c *FakeSites) Update(ctx context.Context, site *v2alpha1.Site, opts v1.UpdateOptions) (result *v2alpha1.Site, err error) {
	emptyResult := &v2alpha1.Site{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(sitesResource, c.ns, site, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.Site), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSites) UpdateStatus(ctx context.Context, site *v2alpha1.Site, opts v1.UpdateOptions) (result *v2alpha1.Site, err error) {
	emptyResult := &v2alpha1.Site{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(sitesResource, "status", c.ns, site, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.Site), err
}

// Delete takes name of the site and deletes it. Returns an error if one occurs.
func (c *FakeSites) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(sitesResource, c.ns, name, opts), &v2alpha1.Site{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSites) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(sitesResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v2alpha1.SiteList{})
	return err
}

// Patch applies the patch and returns the patched site.
func (c *FakeSites) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.Site, err error) {
	emptyResult := &v2alpha1.Site{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(sitesResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.Site), err
}
