/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"net/http"

	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"github.com/skupperproject/skupper/pkg/generated/client/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type SkupperV2alpha1Interface interface {
	RESTClient() rest.Interface
	AccessGrantsGetter
	AccessTokensGetter
	AttachedConnectorsGetter
	AttachedConnectorBindingsGetter
	CertificatesGetter
	ConnectorsGetter
	LinksGetter
	ListenersGetter
	RouterAccessesGetter
	SecuredAccessesGetter
	SitesGetter
}

// SkupperV2alpha1Client is used to interact with features provided by the skupper.io group.
type SkupperV2alpha1Client struct {
	restClient rest.Interface
}

func (c *SkupperV2alpha1Client) AccessGrants(namespace string) AccessGrantInterface {
	return newAccessGrants(c, namespace)
}

func (c *SkupperV2alpha1Client) AccessTokens(namespace string) AccessTokenInterface {
	return newAccessTokens(c, namespace)
}

func (c *SkupperV2alpha1Client) AttachedConnectors(namespace string) AttachedConnectorInterface {
	return newAttachedConnectors(c, namespace)
}

func (c *SkupperV2alpha1Client) AttachedConnectorBindings(namespace string) AttachedConnectorBindingInterface {
	return newAttachedConnectorBindings(c, namespace)
}

func (c *SkupperV2alpha1Client) Certificates(namespace string) CertificateInterface {
	return newCertificates(c, namespace)
}

func (c *SkupperV2alpha1Client) Connectors(namespace string) ConnectorInterface {
	return newConnectors(c, namespace)
}

func (c *SkupperV2alpha1Client) Links(namespace string) LinkInterface {
	return newLinks(c, namespace)
}

func (c *SkupperV2alpha1Client) Listeners(namespace string) ListenerInterface {
	return newListeners(c, namespace)
}

func (c *SkupperV2alpha1Client) RouterAccesses(namespace string) RouterAccessInterface {
	return newRouterAccesses(c, namespace)
}

func (c *SkupperV2alpha1Client) SecuredAccesses(namespace string) SecuredAccessInterface {
	return newSecuredAccesses(c, namespace)
}

func (c *SkupperV2alpha1Client) Sites(namespace string) SiteInterface {
	return newSites(c, namespace)
}

// NewForConfig creates a new SkupperV2alpha1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*SkupperV2alpha1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new SkupperV2alpha1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*SkupperV2alpha1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &SkupperV2alpha1Client{client}, nil
}

// NewForConfigOrDie creates a new SkupperV2alpha1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *SkupperV2alpha1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new SkupperV2alpha1Client for the given RESTClient.
func New(c rest.Interface) *SkupperV2alpha1Client {
	return &SkupperV2alpha1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v2alpha1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *SkupperV2alpha1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
