/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// ConnectorLister helps list Connectors.
// All objects returned here must be treated as read-only.
type ConnectorLister interface {
	// List lists all Connectors in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.Connector, err error)
	// Connectors returns an object that can list and get Connectors.
	Connectors(namespace string) ConnectorNamespaceLister
	ConnectorListerExpansion
}

// connectorLister implements the ConnectorLister interface.
type connectorLister struct {
	listers.ResourceIndexer[*v2alpha1.Connector]
}

// NewConnectorLister returns a new ConnectorLister.
func NewConnectorLister(indexer cache.Indexer) ConnectorLister {
	return &connectorLister{listers.New[*v2alpha1.Connector](indexer, v2alpha1.Resource("connector"))}
}

// Connectors returns an object that can list and get Connectors.
func (s *connectorLister) Connectors(namespace string) ConnectorNamespaceLister {
	return connectorNamespaceLister{listers.NewNamespaced[*v2alpha1.Connector](s.ResourceIndexer, namespace)}
}

// ConnectorNamespaceLister helps list and get Connectors.
// All objects returned here must be treated as read-only.
type ConnectorNamespaceLister interface {
	// List lists all Connectors in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.Connector, err error)
	// Get retrieves the Connector from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.Connector, error)
	ConnectorNamespaceListerExpansion
}

// connectorNamespaceLister implements the ConnectorNamespaceLister
// interface.
type connectorNamespaceLister struct {
	listers.ResourceIndexer[*v2alpha1.Connector]
}
