/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// SecuredAccessLister helps list SecuredAccesses.
// All objects returned here must be treated as read-only.
type SecuredAccessLister interface {
	// List lists all SecuredAccesses in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.SecuredAccess, err error)
	// SecuredAccesses returns an object that can list and get SecuredAccesses.
	SecuredAccesses(namespace string) SecuredAccessNamespaceLister
	SecuredAccessListerExpansion
}

// securedAccessLister implements the SecuredAccessLister interface.
type securedAccessLister struct {
	listers.ResourceIndexer[*v2alpha1.SecuredAccess]
}

// NewSecuredAccessLister returns a new SecuredAccessLister.
func NewSecuredAccessLister(indexer cache.Indexer) SecuredAccessLister {
	return &securedAccessLister{listers.New[*v2alpha1.SecuredAccess](indexer, v2alpha1.Resource("securedaccess"))}
}

// SecuredAccesses returns an object that can list and get SecuredAccesses.
func (s *securedAccessLister) SecuredAccesses(namespace string) SecuredAccessNamespaceLister {
	return securedAccessNamespaceLister{listers.NewNamespaced[*v2alpha1.SecuredAccess](s.ResourceIndexer, namespace)}
}

// SecuredAccessNamespaceLister helps list and get SecuredAccesses.
// All objects returned here must be treated as read-only.
type SecuredAccessNamespaceLister interface {
	// List lists all SecuredAccesses in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.SecuredAccess, err error)
	// Get retrieves the SecuredAccess from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.SecuredAccess, error)
	SecuredAccessNamespaceListerExpansion
}

// securedAccessNamespaceLister implements the SecuredAccessNamespaceLister
// interface.
type securedAccessNamespaceLister struct {
	listers.ResourceIndexer[*v2alpha1.SecuredAccess]
}
