/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;

public class CalendarDecoder
implements DataDecoder {
    public static final String FORMAT = "format";
    private String format;
    private SimpleDateFormat decoder;

    public void setConfiguration(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException {
        this.format = resourceConfig.getStringParameter(FORMAT);
        if (this.format == null) {
            throw new SmooksConfigurationException("Date Decoder must specify a 'format' parameter.");
        }
        this.decoder = new SimpleDateFormat(this.format.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(String data) throws DataDecodeException {
        if (this.decoder == null) {
            throw new IllegalStateException("Calendar decoder not initialised.  A decoder for this type (" + this.getClass().getName() + ") must be explicitly configured (unlike the primitive type decoders) with a date 'format'. See Javadoc.");
        }
        try {
            SimpleDateFormat simpleDateFormat = this.decoder;
            synchronized (simpleDateFormat) {
                this.decoder.parse(data.trim());
                return this.decoder.getCalendar().clone();
            }
        }
        catch (ParseException e) {
            throw new DataDecodeException("Error decoding Date data value '" + data + "' with decode format '" + this.format + "'.", e);
        }
    }
}

