/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.loading.CollectionLoadContext;
import org.hibernate.engine.loading.EntityLoadContext;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.IdentityMap;

public class LoadContexts {
    private static final Log log = LogFactory.getLog((Class)LoadContexts.class);
    private final PersistenceContext persistenceContext;
    private Map collectionLoadContexts;
    private Map entityLoadContexts;

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public CollectionLoadContext getCollectionLoadContext(ResultSet resultSet) {
        CollectionLoadContext context = null;
        if (this.collectionLoadContexts == null) {
            this.collectionLoadContexts = IdentityMap.instantiate(8);
        } else {
            context = (CollectionLoadContext)this.collectionLoadContexts.get(resultSet);
        }
        if (context == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("constructing collection load context for result set [" + resultSet + "]"));
            }
            context = new CollectionLoadContext(this, resultSet);
            this.collectionLoadContexts.put(resultSet, context);
        }
        return context;
    }

    public PersistentCollection locateLoadingCollection(CollectionPersister persister, Serializable ownerKey) {
        LoadingCollectionEntry lce = this.locateLoadingCollectionEntry(new CollectionKey(persister, ownerKey, this.getEntityMode()), null);
        if (lce != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning loading collection:" + MessageHelper.collectionInfoString(persister, ownerKey, this.getSession().getFactory())));
            }
            return lce.getCollection();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("creating collection wrapper:" + MessageHelper.collectionInfoString(persister, ownerKey, this.getSession().getFactory())));
        }
        return null;
    }

    LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey key, CollectionLoadContext caller) {
        if (this.collectionLoadContexts == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to locate loading collection entry [" + key + "] in any result-set context"));
        }
        LoadingCollectionEntry rtn = null;
        Iterator itr = this.collectionLoadContexts.values().iterator();
        while (itr.hasNext()) {
            CollectionLoadContext collectionLoadContext = (CollectionLoadContext)itr.next();
            if (collectionLoadContext == caller || (rtn = collectionLoadContext.getLocalLoadingCollectionEntry(key)) == null) continue;
            if (!log.isTraceEnabled()) break;
            log.trace((Object)("collection [" + key + "] located in load context [" + collectionLoadContext + "]"));
            break;
        }
        return rtn;
    }

    public EntityLoadContext getEntityLoadContext(ResultSet resultSet) {
        EntityLoadContext context = null;
        if (this.entityLoadContexts == null) {
            this.entityLoadContexts = IdentityMap.instantiate(8);
        } else {
            context = (EntityLoadContext)this.entityLoadContexts.get(resultSet);
        }
        if (context == null) {
            context = new EntityLoadContext(this, resultSet);
            this.entityLoadContexts.put(resultSet, context);
        }
        return context;
    }

    public void cleanup(ResultSet resultSet) {
        if (this.collectionLoadContexts != null) {
            CollectionLoadContext collectionLoadContext = (CollectionLoadContext)this.collectionLoadContexts.remove(resultSet);
            collectionLoadContext.cleanup();
        }
        if (this.entityLoadContexts != null) {
            EntityLoadContext entityLoadContext = (EntityLoadContext)this.entityLoadContexts.remove(resultSet);
            entityLoadContext.cleanup();
        }
    }

    private SessionImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    private EntityMode getEntityMode() {
        return this.getSession().getEntityMode();
    }
}

