/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectMethod
extends HttpMethodBase {
    public static final String NAME = "CONNECT";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$ConnectMethod == null ? (class$org$apache$commons$httpclient$ConnectMethod = ConnectMethod.class$("org.apache.commons.httpclient.ConnectMethod")) : class$org$apache$commons$httpclient$ConnectMethod));
    static /* synthetic */ Class class$org$apache$commons$httpclient$ConnectMethod;

    public ConnectMethod() {
        LOG.trace((Object)"enter ConnectMethod()");
    }

    public ConnectMethod(HttpMethod httpMethod) {
        LOG.trace((Object)"enter ConnectMethod(HttpMethod)");
    }

    public String getName() {
        return NAME;
    }

    protected void addCookieRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
    }

    protected void addRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter ConnectMethod.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(httpState, httpConnection);
        this.addHostRequestHeader(httpState, httpConnection);
        this.addProxyConnectionHeader(httpState, httpConnection);
    }

    public int execute(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter ConnectMethod.execute(HttpState, HttpConnection)");
        int n = super.execute(httpState, httpConnection);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CONNECT status code " + n));
        }
        return n;
    }

    protected void writeRequestLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        int n = httpConnection.getPort();
        if (n == -1) {
            n = httpConnection.getProtocol().getDefaultPort();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(' ');
        stringBuffer.append(httpConnection.getHost());
        if (n > -1) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getEffectiveVersion());
        String string = stringBuffer.toString();
        httpConnection.printLine(string, this.getParams().getHttpElementCharset());
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(string);
        }
    }

    protected boolean shouldCloseConnection(HttpConnection httpConnection) {
        if (this.getStatusCode() == 200) {
            Header header = null;
            if (!httpConnection.isTransparent()) {
                header = this.getResponseHeader("proxy-connection");
            }
            if (header == null) {
                header = this.getResponseHeader("connection");
            }
            if (header != null && header.getValue().equalsIgnoreCase("close") && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid header encountered '" + header.toExternalForm() + "' in response " + this.getStatusLine().toString()));
            }
            return false;
        }
        return super.shouldCloseConnection(httpConnection);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

