/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ContainerRequest;
import org.milyn.xml.SmooksXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class CSVParser
implements SmooksXMLReader {
    private static Log logger = LogFactory.getLog(CSVParser.class);
    private static final String CVS_SET_EL = "csv-set";
    private static final String CVS_RECORD_EL = "csv-record";
    private static Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private ContentHandler contentHandler;
    private SmooksResourceConfiguration configuration;
    private ContainerRequest request;

    public void setConfiguration(SmooksResourceConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setRequest(ContainerRequest request) {
        this.request = request;
    }

    public void parse(InputSource csvInputSource) throws IOException, SAXException {
        String[] csvRecord;
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse CSV stream.");
        }
        if (this.configuration == null) {
            throw new IllegalStateException("CSV to SAX Parser 'configuration' not set.  Cannot parse CSV stream.");
        }
        if (this.request == null) {
            throw new IllegalStateException("Smooks container 'request' not set.  Cannot parse CSV stream.");
        }
        Parameter csvFieldsParam = this.configuration.getParameter("fields");
        List csvFields = (List)csvFieldsParam.getValue(this.request.getDeliveryConfig());
        if (csvFields == null || csvFields.isEmpty()) {
            throw new SAXException("Invalid configuration for the CSV to SAX Parser [" + this.configuration + "].  No comma separated CVS 'fields' param specified.  The 'fields' param specifies CVS field to XML element name mappings.");
        }
        Reader csvStreamReader = csvInputSource.getCharacterStream();
        if (csvStreamReader == null) {
            csvStreamReader = new InputStreamReader(csvInputSource.getByteStream());
        }
        CSVReader csvLineReader = new CSVReader(csvStreamReader);
        this.contentHandler.startDocument();
        this.contentHandler.startElement(null, CVS_SET_EL, "", EMPTY_ATTRIBS);
        int lineNumber = 0;
        while ((csvRecord = csvLineReader.readNext()) != null) {
            ++lineNumber;
            if (csvRecord.length != csvFields.size()) {
                logger.warn((Object)("[CORRUPT-CSV] CSV line #" + lineNumber + " invalid [" + Arrays.asList(csvRecord) + "].  The line should contain the following " + csvFields.size() + " fields [" + csvFields + "], but contains " + csvRecord.length + " fields.  Ignoring!!"));
                continue;
            }
            this.contentHandler.startElement(null, CVS_RECORD_EL, "", EMPTY_ATTRIBS);
            for (int i = 0; i < csvRecord.length; ++i) {
                String fieldName = (String)csvFields.get(i);
                this.contentHandler.startElement(null, fieldName, "", EMPTY_ATTRIBS);
                this.contentHandler.characters(csvRecord[i].toCharArray(), 0, csvRecord[i].length());
                this.contentHandler.endElement(null, fieldName, "");
            }
            this.contentHandler.endElement(null, CVS_RECORD_EL, "");
        }
        this.contentHandler.endElement(null, CVS_SET_EL, "");
        this.contentHandler.endDocument();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

