/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.io.PrintStream;
import java.lang.reflect.Field;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.mvel.tests.perftests.NullOutputStream;
import sun.misc.Unsafe;

public class SimpleTests {
    private static final Unsafe unsafe__ = SimpleTests.getUnsafe();

    public static void main(String[] args) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.mvel.tests.main.CoreConfidenceTests");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TestSuite testSuite = new TestSuite(clazz);
        TestResult result = new TestResult();
        PrintStream ps = System.out;
        System.setOut(new PrintStream(new NullOutputStream()));
        System.setErr(new PrintStream(new NullOutputStream()));
        testSuite.run(result);
        int i = 0;
        while (i < 100) {
            long time = System.currentTimeMillis();
            testSuite.run(result);
            ps.println("Result: " + (System.currentTimeMillis() - time));
            ++i;
        }
        System.setOut(ps);
    }

    private static Unsafe getUnsafe() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("sun.misc.Unsafe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException("can't get Unsafe instance", ex);
        }
    }

    private static void setBoolean(Field f, Object o, boolean v) {
        unsafe__.putBoolean(o, unsafe__.objectFieldOffset(f), v);
    }

    private static Object newInstance(Class clazz) throws Exception {
        return unsafe__.allocateInstance(clazz);
    }
}

