/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mvel.ImmutableElementException;

public class FastList
extends AbstractList {
    private Object[] elements;
    private int size = 0;
    private boolean updated = false;

    public FastList(int size) {
        this.elements = new Object[size];
    }

    public FastList(Object[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    public Object get(int index) {
        return this.elements[index];
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object o) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        this.elements[this.size++] = o;
        return true;
    }

    public Object set(int i, Object o) {
        if (!this.updated) {
            this.copyArray();
        }
        Object old = this.elements[i];
        this.elements[i] = o;
        return old;
    }

    public void add(int i, Object o) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        int c = this.size;
        while (c != i) {
            this.elements[c] = this.elements[c - 1];
            --c;
        }
        this.elements[i] = o;
        ++this.size;
    }

    public Object remove(int i) {
        Object old = this.elements[i];
        int c = i + 1;
        while (c != this.size) {
            this.elements[c - 1] = this.elements[c];
            --c;
        }
        --this.size;
        return old;
    }

    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        int i = 0;
        while (i < this.elements.length) {
            if (o.equals(this.elements[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        int i = this.elements.length - 1;
        while (i != -1) {
            if (o.equals(this.elements[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void clear() {
        this.elements = new Object[0];
    }

    public boolean addAll(int i, Collection collection) {
        int offset = collection.size();
        this.ensureCapacity(offset);
        int c = i;
        while (c != i + offset) {
            this.elements[c + offset + 1] = this.elements[c];
            ++c;
        }
        c = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            this.elements[offset + c] = o;
        }
        return true;
    }

    public Iterator iterator() {
        final int size = this.size;
        return new Iterator(){
            private int cursor = 0;

            public boolean hasNext() {
                return this.cursor < size;
            }

            public Object next() {
                return FastList.this.elements[this.cursor++];
            }

            public void remove() {
                throw new ImmutableElementException("cannot change elements in immutable list");
            }
        };
    }

    public ListIterator listIterator() {
        return super.listIterator();
    }

    public ListIterator listIterator(int i) {
        return super.listIterator(i);
    }

    public List subList(int i, int i1) {
        return super.subList(i, i1);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected void removeRange(int i, int i1) {
        throw new RuntimeException("not implemented");
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public Object[] toArray() {
        if (!this.updated) {
            this.copyArray();
        }
        return this.elements;
    }

    public Object[] toArray(Object[] objects) {
        throw new RuntimeException("not implemented");
    }

    public boolean remove(Object o) {
        throw new RuntimeException("not implemented");
    }

    public boolean containsAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean removeAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    public boolean retainAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    private void ensureCapacity(int additional) {
        if (this.size + additional > this.elements.length) {
            this.increaseSize((this.size + additional) * 2);
        }
    }

    private void copyArray() {
        this.increaseSize(this.elements.length);
    }

    private void increaseSize(int newSize) {
        Object[] newElements = new Object[newSize];
        int i = 0;
        while (i < this.elements.length) {
            newElements[i] = this.elements[i];
            ++i;
        }
        this.elements = newElements;
        this.updated = true;
    }

    public String toString() {
        return super.toString();
    }
}

