/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.util.Iterator;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.ast.BlockNode;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel.integration.impl.ItemResolverFactory;
import org.mvel.util.ParseTools;

public class ForEachNode
extends BlockNode {
    protected String item;
    protected ExecutableStatement condition;
    protected ExecutableStatement compiledBlock;

    public ForEachNode(char[] condition, char[] block, int fields) {
        super(condition, fields);
        this.handleCond(condition);
        this.block = block;
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(block);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver(this.item);
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        Object iterCond = this.condition.getValue(ctx, thisValue, factory);
        if (iterCond instanceof Iterable) {
            Iterator iterator = ((Iterable)iterCond).iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                itemR.setValue(o);
                this.compiledBlock.getValue(ctx, thisValue, itemFactory);
            }
        } else if (iterCond instanceof Object[]) {
            Object[] objectArray = (Object[])iterCond;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object o = objectArray[n];
                itemR.setValue(o);
                this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                ++n;
            }
        } else if (iterCond instanceof CharSequence) {
            char[] cArray = iterCond.toString().toCharArray();
            int n = 0;
            int n3 = cArray.length;
            while (n < n3) {
                Character o = new Character(cArray[n]);
                itemR.setValue(o);
                this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                ++n;
            }
        } else if (iterCond instanceof Integer) {
            int max = (Integer)iterCond + 1;
            int i = 1;
            while (i != max) {
                itemR.setValue(new Integer(i));
                this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                ++i;
            }
        } else {
            throw new CompileException("non-iterable type: " + iterCond.getClass().getName());
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    private void handleCond(char[] condition) {
        int cursor = 0;
        while (cursor < condition.length && condition[cursor] != ':') {
            ++cursor;
        }
        if (cursor == condition.length || condition[cursor] != ':') {
            throw new CompileException("expected : in foreach");
        }
        this.item = new String(condition, 0, cursor).trim();
        this.condition = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(condition, ++cursor));
    }
}

