/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ArrayTools;
import org.mvel.util.ParseTools;

public class StaticImportNode
extends ASTNode {
    private Class declaringClass;
    private String methodName;
    private transient Method method;

    public StaticImportNode(char[] expr, int fields) {
        super(expr, fields);
        try {
            this.declaringClass = Thread.currentThread().getContextClassLoader().loadClass(new String(ParseTools.subset(expr, 0, ArrayTools.findLast('.', expr))));
            this.methodName = new String(ParseTools.subset(expr, ArrayTools.findLast('.', expr) + 1));
            if (this.resolveMethod() == null) {
                throw new CompileException("can not find method for static import: " + this.declaringClass.getName() + "." + this.methodName);
            }
        }
        catch (Exception e) {
            throw new CompileException("unable to import class", e);
        }
    }

    private Method resolveMethod() {
        Method[] methodArray = this.declaringClass.getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method meth = methodArray[n];
            if (Modifier.isStatic(meth.getModifiers()) && this.methodName.equals(meth.getName())) {
                this.method = meth;
                return this.method;
            }
            ++n;
        }
        return null;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        ParseTools.findStaticMethodImportResolverFactory(factory).createVariable(this.methodName, this.method);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }
}

