/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ast.Assignment;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class TypedVarNode
extends ASTNode
implements Assignment {
    private String name;
    private char[] stmt;
    private transient ExecutableStatement statement;

    public TypedVarNode(char[] expr, int fields, Class type) {
        super(expr, fields);
        this.egressType = type;
        int assignStart = PropertyTools.find(expr, '=');
        if (assignStart != -1) {
            this.name = new String(expr, 0, assignStart).trim();
            ParseTools.checkNameSafety(this.name);
            if (((fields |= 0x800) & 0x10) != 0) {
                this.stmt = ParseTools.subset(expr, assignStart + 1);
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
            } else {
                this.stmt = ParseTools.subset(expr, assignStart + 1);
            }
        } else {
            this.name = new String(expr);
            ParseTools.checkNameSafety(this.name);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
        }
        ctx = this.statement.getValue(ctx, thisValue, factory);
        ParseTools.finalLocalVariableFactory(factory).createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.stmt, thisValue, factory);
        ParseTools.finalLocalVariableFactory(factory).createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignmentVar() {
        return this.name;
    }
}

