/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.mvel.util.ReflectionUtil;

public class PropertyTools {
    public static boolean isEmpty(Object o) {
        if (o != null) {
            if (o instanceof Object[]) {
                return ((Object[])o).length == 0 || ((Object[])o).length == 1 && PropertyTools.isEmpty(((Object[])o)[0]);
            }
            return "".equals(String.valueOf(o)) || "null".equals(String.valueOf(o)) || o instanceof Collection && ((Collection)o).size() == 0 || o instanceof Map && ((Map)o).size() == 0;
        }
        return true;
    }

    public static Method getSetter(Class clazz, String property) {
        property = ReflectionUtil.getSetter(property);
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method meth = methodArray[n];
            if (((meth.getModifiers() & 1) != 0 || meth.getParameterTypes().length == 0) && property.equals(meth.getName())) {
                return meth;
            }
            ++n;
        }
        return null;
    }

    public static boolean hasGetter(Field field) {
        Method meth = PropertyTools.getGetter(field.getDeclaringClass(), field.getName());
        return meth != null && field.getType().isAssignableFrom(meth.getReturnType());
    }

    public static boolean hasSetter(Field field) {
        Method meth = PropertyTools.getSetter(field.getDeclaringClass(), field.getName());
        return meth != null && meth.getParameterTypes().length == 1 && field.getType().isAssignableFrom(meth.getParameterTypes()[0]);
    }

    public static Method getGetter(Class clazz, String property) {
        String isGet = ReflectionUtil.getIsGetter(property);
        property = ReflectionUtil.getGetter(property);
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method meth = methodArray[n];
            if ((meth.getModifiers() & 1) != 0 && meth.getParameterTypes().length == 0 && (property.equals(meth.getName()) || isGet.equals(meth.getName()))) {
                return meth;
            }
            ++n;
        }
        return null;
    }

    public static boolean isPropertyReadAndWrite(Field field) {
        return Modifier.isPublic(field.getModifiers()) || PropertyTools.hasGetter(field) && PropertyTools.hasSetter(field);
    }

    public static boolean isPropertyReadAndWrite(Class clazz, String property) {
        return PropertyTools.getWritableFieldOrAccessor(clazz, property) != null && PropertyTools.getFieldOrAccessor(clazz, property) != null;
    }

    public static Member getWritableFieldOrAccessor(Class clazz, String property) {
        try {
            Field field = clazz.getField(property);
            if (field != null && Modifier.isPublic(field.getModifiers())) {
                return field;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return PropertyTools.getSetter(clazz, property);
    }

    public static Member getFieldOrAccessor(Class clazz, String property) {
        if (property.charAt(property.length() - 1) == ')') {
            return PropertyTools.getGetter(clazz, property);
        }
        try {
            Field fld = clazz.getField(property);
            if ((fld.getModifiers() & 1) != 0) {
                return fld;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PropertyTools.getGetter(clazz, property);
    }

    public static Member getFieldOrWriteAccessor(Class clazz, String property) {
        try {
            Field field = clazz.getField(property);
            if (field != null && Modifier.isPublic(field.getModifiers())) {
                return field;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return PropertyTools.getSetter(clazz, property);
    }

    public static boolean isNumeric(Object val) {
        if (val == null) {
            return false;
        }
        Class<?> clz = val instanceof Class ? (Class<?>)val : val.getClass();
        if (clz != Integer.TYPE && clz != Long.TYPE && clz != Short.TYPE && clz != Double.TYPE && clz != Float.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!clazz.isAssignableFrom(clz)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNumber(char[] val) {
        int len = val.length;
        int i = 0;
        if (len > 1) {
            if (val[0] == '-') {
                ++i;
            } else if (val[0] == '~') {
                ++i;
                if (val[1] == '-') {
                    ++i;
                }
            }
        }
        while (i < len) {
            char c = val[i];
            if (!PropertyTools.isDigit(c) && c != '.') {
                return false;
            }
            ++i;
        }
        return len > 0;
    }

    public static Object handleNumericConversion(char[] val) {
        switch (PropertyTools.numericTest(val)) {
            case 104: {
                return new Float(Float.parseFloat(new String(val)));
            }
            case 101: {
                return new Integer(Integer.parseInt(new String(val)));
            }
            case 102: {
                return new Long(Long.parseLong(new String(val)));
            }
            case 103: {
                return new Double(Double.parseDouble(new String(val)));
            }
            case 110: {
                return new BigDecimal(new String(val));
            }
        }
        return new String(val);
    }

    public static int numericTest(char[] val) {
        boolean fp = false;
        int len = val.length;
        int i = 0;
        if (len > 1) {
            if (val[0] == '-') {
                ++i;
            } else if (val[0] == '~') {
                ++i;
                if (val[1] == '-') {
                    ++i;
                }
            }
        }
        while (i < len) {
            char c = val[i];
            if (!PropertyTools.isDigit(c)) {
                if (c == '.') {
                    len = 0;
                    fp = true;
                } else {
                    return -1;
                }
            }
            ++i;
        }
        if (len > 0) {
            if (fp) {
                if (len > 17) {
                    return 110;
                }
                if (len > 15) {
                    return 104;
                }
                return 103;
            }
            if (len > 11) {
                return 110;
            }
            if (len > 9) {
                return 102;
            }
            return 101;
        }
        return -1;
    }

    public static boolean isNumber(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            return PropertyTools.isNumber((String)val);
        }
        if (val instanceof char[]) {
            return PropertyTools.isNumber((char[])val);
        }
        return val instanceof Integer || val instanceof BigDecimal || val instanceof BigInteger || val instanceof Float || val instanceof Double || val instanceof Long || val instanceof Short || val instanceof Character;
    }

    public static boolean isNumber(String val) {
        int len = val.length();
        char[] a = val.toCharArray();
        int i = 0;
        if (len > 1) {
            if (a[0] == '-') {
                ++i;
            } else if (a[0] == '~') {
                ++i;
                if (a[1] == '-') {
                    ++i;
                }
            }
        }
        while (i < len) {
            char c = a[i];
            if (!PropertyTools.isDigit(c) && c != '.') {
                return false;
            }
            ++i;
        }
        return len > 0;
    }

    public static boolean contains(Object toCompare, Object testValue) {
        if (toCompare == null) {
            return false;
        }
        if (toCompare instanceof String) {
            return ((String)toCompare).indexOf(String.valueOf(testValue).toString()) > -1;
        }
        if (toCompare instanceof Collection) {
            return ((Collection)toCompare).contains(testValue);
        }
        if (toCompare instanceof Map) {
            return ((Map)toCompare).containsKey(testValue);
        }
        if (toCompare.getClass().isArray()) {
            Object[] objectArray = (Object[])toCompare;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object o = objectArray[n];
                if (testValue == null && o == null) {
                    return true;
                }
                if (o != null && o.equals(testValue)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static int find(char[] c, char find) {
        int i = 0;
        while (i < c.length) {
            if (c[i] == find) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean equals(char[] obj1, String obj2) {
        int i = 0;
        while (i < obj1.length && i < obj2.length()) {
            if (obj1[i] == obj2.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIdentifierPart(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c == 36;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static float similarity(String s1, String s2) {
        char[] against;
        char[] comp;
        float baselength;
        if (s1 == null || s2 == null) {
            return s1 == null && s2 == null ? 1.0f : 0.0f;
        }
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        float same = 0.0f;
        int cur1 = 0;
        if (c1.length > c2.length) {
            baselength = c1.length;
            comp = c1;
            against = c2;
        } else {
            baselength = c2.length;
            comp = c2;
            against = c1;
        }
        while (cur1 < comp.length && cur1 < against.length) {
            if (comp[cur1] == against[cur1]) {
                same += 1.0f;
            }
            ++cur1;
        }
        if (c1.length != c2.length) {
            int offset = comp.length - against.length;
            int cur2 = --cur1 - offset;
            while (cur1 > 0 && cur1 < comp.length && cur2 > -1 && cur2 < against.length) {
                if (comp[cur1] == against[cur2]) {
                    same += 1.0f;
                    ++cur2;
                    ++cur1;
                    continue;
                }
                cur2 = --cur1 - offset;
            }
        }
        return same / baselength;
    }

    public static int findAbsoluteLast(char[] array) {
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == '.' || array[i] == '[') {
                return i;
            }
            --i;
        }
        return -1;
    }
}

