/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.h2.Driver;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.TcpServerThread;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class TcpServer
implements Service {
    public static final int DEFAULT_PORT = 9092;
    public static final int SHUTDOWN_NORMAL = 0;
    public static final int SHUTDOWN_FORCE = 1;
    public static boolean logInternalErrors;
    private int port;
    private boolean log;
    private boolean ssl;
    private boolean stop;
    private ServerSocket serverSocket;
    private Set running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private String url;
    private boolean allowOthers;
    private boolean ifExists;
    private Connection managementDb;
    private PreparedStatement managementDbAdd;
    private PreparedStatement managementDbRemove;
    private String managementPassword = "";
    private static final Map SERVERS;
    private Thread listenerThread;
    private int nextThreadId;
    static /* synthetic */ Class class$org$h2$server$TcpServer;

    public static String getManagementDbName(int port) {
        return "mem:management_db_" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initManagementDb() throws SQLException {
        Connection conn;
        Properties prop = new Properties();
        prop.setProperty("user", "sa");
        prop.setProperty("password", this.managementPassword);
        this.managementDb = conn = Driver.load().connect("jdbc:h2:" + TcpServer.getManagementDbName(this.port), prop);
        Statement stat = null;
        try {
            stat = conn.createStatement();
            stat.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR \"" + (class$org$h2$server$TcpServer == null ? (class$org$h2$server$TcpServer = TcpServer.class$("org.h2.server.TcpServer")) : class$org$h2$server$TcpServer).getName() + ".stopServer\"");
            stat.execute("CREATE TABLE IF NOT EXISTS SESSIONS(ID INT PRIMARY KEY, URL VARCHAR, USER VARCHAR, CONNECTED TIMESTAMP)");
            this.managementDbAdd = conn.prepareStatement("INSERT INTO SESSIONS VALUES(?, ?, ?, NOW())");
            this.managementDbRemove = conn.prepareStatement("DELETE FROM SESSIONS WHERE ID=?");
        }
        finally {
            JdbcUtils.closeSilently(stat);
        }
        SERVERS.put("" + this.port, this);
    }

    public static int[] getAllServerPorts() {
        Object[] servers = SERVERS.keySet().toArray();
        int[] ports = new int[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            ports[i] = Integer.parseInt(servers[i].toString());
        }
        return ports;
    }

    synchronized void addConnection(int id, String url, String user) {
        try {
            this.managementDbAdd.setInt(1, id);
            this.managementDbAdd.setString(2, url);
            this.managementDbAdd.setString(3, user);
            this.managementDbAdd.execute();
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
    }

    synchronized void removeConnection(int id) {
        try {
            this.managementDbRemove.setInt(1, id);
            this.managementDbRemove.execute();
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopManagementDb() {
        Class clazz = class$org$h2$server$TcpServer == null ? (class$org$h2$server$TcpServer = TcpServer.class$("org.h2.server.TcpServer")) : class$org$h2$server$TcpServer;
        synchronized (clazz) {
            if (this.managementDb != null) {
                try {
                    this.managementDb.close();
                }
                catch (SQLException e) {
                    TraceSystem.traceThrowable(e);
                }
                this.managementDb = null;
            }
        }
    }

    public void init(String[] args) throws Exception {
        this.port = 9092;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if ("-log".equals(a)) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-tcpSSL".equals(a)) {
                this.ssl = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-tcpPort".equals(a)) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if ("-tcpPassword".equals(a)) {
                this.managementPassword = args[++i];
                continue;
            }
            if ("-baseDir".equals(a)) {
                this.baseDir = args[++i];
                continue;
            }
            if ("-tcpAllowOthers".equals(a)) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!"-ifExists".equals(a)) continue;
            this.ifExists = Boolean.valueOf(args[++i]);
        }
        Driver.load();
        this.url = (this.ssl ? "ssl" : "tcp") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        return NetUtils.isLoopbackAddress(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SQLException {
        Class clazz = class$org$h2$server$TcpServer == null ? (class$org$h2$server$TcpServer = TcpServer.class$("org.h2.server.TcpServer")) : class$org$h2$server$TcpServer;
        synchronized (clazz) {
            this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
            this.initManagementDb();
        }
    }

    public void listen() {
        block3: {
            this.listenerThread = Thread.currentThread();
            String threadName = this.listenerThread.getName();
            try {
                while (!this.stop) {
                    Socket s = this.serverSocket.accept();
                    TcpServerThread c = new TcpServerThread(s, this, this.nextThreadId++);
                    this.running.add(c);
                    Thread thread = new Thread(c);
                    thread.setName(threadName + " thread");
                    c.setThread(thread);
                    thread.start();
                }
                this.serverSocket = NetUtils.closeSilently(this.serverSocket);
            }
            catch (Exception e) {
                if (this.stop) break block3;
                TraceSystem.traceThrowable(e);
            }
        }
        this.stopManagementDb();
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, this.ssl);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized void stop() {
        if (!this.stop) {
            this.stopManagementDb();
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    TraceSystem.traceThrowable(e);
                }
                this.serverSocket = null;
            }
            if (this.listenerThread != null) {
                try {
                    this.listenerThread.join(1000L);
                }
                catch (InterruptedException e) {
                    TraceSystem.traceThrowable(e);
                }
            }
        }
        ArrayList list = new ArrayList(this.running);
        for (int i = 0; i < list.size(); ++i) {
            TcpServerThread c = (TcpServerThread)list.get(i);
            c.close();
            try {
                c.getThread().join(100L);
                continue;
            }
            catch (Exception e) {
                TraceSystem.traceThrowable(e);
            }
        }
        SERVERS.remove("" + this.port);
    }

    public static synchronized void stopServer(int port, String password, int shutdownMode) {
        TcpServer server = (TcpServer)SERVERS.get("" + port);
        if (server == null) {
            return;
        }
        if (!server.managementPassword.equals(password)) {
            return;
        }
        if (shutdownMode == 0) {
            server.stopManagementDb();
            server.stop = true;
            try {
                Socket s = NetUtils.createLoopbackSocket(port, false);
                s.close();
            }
            catch (Exception e) {}
        } else if (shutdownMode == 1) {
            server.stop();
        }
    }

    synchronized void remove(TcpServerThread t) {
        this.running.remove(t);
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    void logError(Throwable e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "TCP";
    }

    public String getName() {
        return "H2 TCP Server";
    }

    public void logInternalError(String string) {
        if (logInternalErrors) {
            System.out.println(string);
            new Error(string).printStackTrace();
        }
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SERVERS = Collections.synchronizedMap(new HashMap());
    }
}

