/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Server;
import org.h2.util.IOUtils;
import org.h2.util.StartBrowser;

public class Console
implements ActionListener,
MouseListener,
ShutdownHandler {
    private Font font;
    private Image icon;
    private Frame frame;
    private static final int EXIT_ERROR = 1;
    private Server web;
    private Server tcp;
    private Server pg;
    static /* synthetic */ Class class$org$h2$tools$Console;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$PopupMenu;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    public static void main(String[] args) throws Exception {
        int exitCode = new Console().run(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    private int run(String[] args) {
        int exitCode = 0;
        try {
            this.web = Server.createWebServer(args);
            this.web.setShutdownHandler(this);
            this.web.start();
        }
        catch (SQLException e) {
            if (this.web == null) {
                e.printStackTrace();
            }
            System.out.println(this.web.getStatus());
        }
        try {
            this.tcp = Server.createTcpServer(args);
            this.tcp.start();
        }
        catch (SQLException e) {
            if (this.tcp == null) {
                e.printStackTrace();
            }
            System.out.println(this.tcp.getStatus());
        }
        try {
            this.pg = Server.createPgServer(args);
            this.pg.start();
        }
        catch (SQLException e) {
            if (this.pg == null) {
                e.printStackTrace();
            }
            System.out.println(this.pg.getStatus());
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.font = new Font("Dialog", 0, 11);
            try {
                InputStream in = (class$org$h2$tools$Console == null ? (class$org$h2$tools$Console = Console.class$("org.h2.tools.Console")) : class$org$h2$tools$Console).getResourceAsStream("/org/h2/res/h2.png");
                if (in != null) {
                    byte[] imageData = IOUtils.readBytesAndClose(in, -1);
                    this.icon = Toolkit.getDefaultToolkit().createImage(imageData);
                }
                if (!this.createTrayIcon()) {
                    this.showWindow(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StartBrowser.openURL(this.web.getURL());
        if (!this.web.isRunning()) {
            exitCode = 1;
        }
        return exitCode;
    }

    public void shutdown() {
        this.stopAll();
    }

    private void stopAll() {
        if (this.web != null && this.web.isRunning()) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning()) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning()) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        System.exit(0);
    }

    private boolean createTrayIcon() {
        try {
            Boolean supported = (Boolean)Class.forName("java.awt.SystemTray").getMethod("isSupported", new Class[0]).invoke(null, new Object[0]);
            if (!supported.booleanValue()) {
                return false;
            }
            PopupMenu menuConsole = new PopupMenu();
            MenuItem itemConsole = new MenuItem("H2 Console");
            itemConsole.setActionCommand("console");
            itemConsole.addActionListener(this);
            itemConsole.setFont(this.font);
            menuConsole.add(itemConsole);
            MenuItem itemStatus = new MenuItem("Status");
            itemStatus.setActionCommand("status");
            itemStatus.addActionListener(this);
            itemStatus.setFont(this.font);
            menuConsole.add(itemStatus);
            MenuItem itemExit = new MenuItem("Exit");
            itemExit.setFont(this.font);
            itemExit.setActionCommand("exit");
            itemExit.addActionListener(this);
            menuConsole.add(itemExit);
            Object trayIcon = Class.forName("java.awt.TrayIcon").getConstructor(class$java$awt$Image == null ? (class$java$awt$Image = Console.class$("java.awt.Image")) : class$java$awt$Image, class$java$lang$String == null ? (class$java$lang$String = Console.class$("java.lang.String")) : class$java$lang$String, class$java$awt$PopupMenu == null ? (class$java$awt$PopupMenu = Console.class$("java.awt.PopupMenu")) : class$java$awt$PopupMenu).newInstance(this.icon, "H2 Database Engine", menuConsole);
            Object tray = Class.forName("java.awt.SystemTray").getMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]);
            trayIcon.getClass().getMethod("addMouseListener", class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = Console.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener).invoke(trayIcon, this);
            tray.getClass().getMethod("add", Class.forName("java.awt.TrayIcon")).invoke(tray, trayIcon);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void showWindow(final boolean exit) {
        this.frame = new Frame("H2 Console");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                if (exit) {
                    Console.this.stopAll();
                } else {
                    Console.this.frame.dispose();
                }
            }
        });
        if (this.icon != null) {
            this.frame.setIconImage(this.icon);
        }
        this.frame.setResizable(false);
        this.frame.setBackground(SystemColor.control);
        GridBagLayout layout = new GridBagLayout();
        this.frame.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.insets.left = 2;
        c.insets.right = 2;
        c.insets.top = 2;
        c.insets.bottom = 2;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(this.font);
        c.anchor = 17;
        c.gridwidth = 13;
        this.frame.add((Component)label, c);
        TextField text = new TextField();
        text.setEditable(false);
        text.setFont(this.font);
        text.setText(this.web.getURL());
        text.setFocusable(false);
        c.anchor = 13;
        c.gridwidth = 0;
        this.frame.add((Component)text, c);
        Label label2 = new Label();
        c.anchor = 17;
        c.gridwidth = 13;
        this.frame.add((Component)label2, c);
        Button startBrowser = new Button("Start Browser");
        startBrowser.setFocusable(false);
        startBrowser.setActionCommand("console");
        startBrowser.addActionListener(this);
        startBrowser.setFont(this.font);
        c.anchor = 13;
        c.gridwidth = 0;
        this.frame.add((Component)startBrowser, c);
        int width = 250;
        int height = 120;
        this.frame.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        try {
            this.frame.setVisible(true);
        }
        catch (Throwable t) {
            System.out.println("URL: " + this.web.getURL());
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            StartBrowser.openURL(this.web.getURL());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("exit".equals(command)) {
            this.stopAll();
        } else if ("console".equals(command)) {
            this.startBrowser();
        } else if ("status".equals(command)) {
            this.showWindow(false);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.startBrowser();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

