/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.server.ftp.FtpServer;
import org.h2.server.pg.PgServer;
import org.h2.server.web.WebServer;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.StartBrowser;

public class Server
implements Runnable,
ShutdownHandler {
    private Service service;
    private static final int EXIT_ERROR = 1;
    private Server web;
    private Server tcp;
    private Server pg;
    private Server ftp;
    private ShutdownHandler shutdownHandler;

    private void showUsage(String a, PrintStream out) {
        if (a != null) {
            out.println("Unknown option: " + a);
            out.println();
        }
        out.println("java " + this.getClass().getName() + " [options]");
        out.println("By default, -tcp, -web, -browser and -pg are started.");
        out.println("Options are case sensitive. Options:");
        out.println();
        out.println("-web (start the Web Server and H2 Console)");
        out.println("-webAllowOthers [true|false}");
        out.println("-webPort <port> (default: 8082)");
        out.println("-webSSL [true|false}");
        out.println();
        out.println("-browser (start a browser to connect to the H2 Console)");
        out.println();
        out.println("-tcp (start the TCP Server)");
        out.println("-tcpAllowOthers {true|false}");
        out.println("-tcpPort <port> (default: 9092)");
        out.println("-tcpSSL {true|false}");
        out.println("-tcpPassword {password} (the password for shutting down a TCP Server)");
        out.println("-tcpShutdown {url} (shutdown the TCP Server, URL example: tcp://localhost:9094)");
        out.println("-tcpShutdownForce {true|false} (don't wait for other connections to close)");
        out.println();
        out.println("-pg (start the PG Server)");
        out.println("-pgAllowOthers {true|false}");
        out.println("-pgPort <port> (default: 5435)");
        out.println();
        out.println("-ftp (start the FTP Server)");
        out.println("-ftpPort <port> (default: 8021)");
        out.println("-ftpDir <directory> (default: ftp, use jdbc:... to access a database)");
        out.println("-ftpRead <readUserName> (default: guest)");
        out.println("-ftpWrite <writeUserName> (default: sa)");
        out.println("-ftpWritePassword <password> (default: sa)");
        out.println();
        out.println("-log {true|false} (enable or disable logging, for all servers)");
        out.println("-baseDir <directory> (sets the base directory for H2 databases, for all servers)");
        out.println("-ifExists {true|false} (only existing databases may be opened, for all servers)");
    }

    public Server() {
    }

    public static void main(String[] args) throws SQLException {
        int exitCode = new Server().run(args, System.out);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public int run(String[] args, PrintStream out) throws SQLException {
        boolean tcpStart = false;
        boolean pgStart = false;
        boolean webStart = false;
        boolean ftpStart = false;
        boolean browserStart = false;
        boolean tcpShutdown = false;
        boolean tcpShutdownForce = false;
        String tcpPassword = "";
        String tcpShutdownServer = "";
        boolean startDefaultServers = true;
        for (int i = 0; args != null && i < args.length; ++i) {
            String a = args[i];
            if (a == null) continue;
            if ("-?".equals(a) || "-help".equals(a)) {
                this.showUsage(null, out);
                return 1;
            }
            if (a.startsWith("-web")) {
                if ("-web".equals(a)) {
                    startDefaultServers = false;
                    webStart = true;
                    continue;
                }
                if ("-webAllowOthers".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-webPort".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-webScript".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-webSSL".equals(a)) {
                    ++i;
                    continue;
                }
                this.showUsage(a, out);
                return 1;
            }
            if ("-browser".equals(a)) {
                startDefaultServers = false;
                browserStart = true;
                continue;
            }
            if (a.startsWith("-tcp")) {
                if ("-tcp".equals(a)) {
                    startDefaultServers = false;
                    tcpStart = true;
                    continue;
                }
                if ("-tcpAllowOthers".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-tcpPort".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-tcpSSL".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-tcpPassword".equals(a)) {
                    tcpPassword = args[++i];
                    continue;
                }
                if ("-tcpShutdown".equals(a)) {
                    startDefaultServers = false;
                    tcpShutdown = true;
                    tcpShutdownServer = args[++i];
                    continue;
                }
                if ("-tcpShutdownForce".equals(a)) {
                    tcpShutdownForce = Boolean.valueOf(args[++i]);
                    continue;
                }
                this.showUsage(a, out);
                return 1;
            }
            if (a.startsWith("-pg")) {
                if ("-pg".equals(a)) {
                    startDefaultServers = false;
                    pgStart = true;
                    continue;
                }
                if ("-pgAllowOthers".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-pgPort".equals(a)) {
                    ++i;
                    continue;
                }
                this.showUsage(a, out);
                return 1;
            }
            if (a.startsWith("-ftp")) {
                if ("-ftp".equals(a)) {
                    startDefaultServers = false;
                    ftpStart = true;
                    continue;
                }
                if ("-ftpPort".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-ftpDir".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-ftpRead".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-ftpWrite".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-ftpWritePassword".equals(a)) {
                    ++i;
                    continue;
                }
                if ("-ftpTask".equals(a)) {
                    ++i;
                    continue;
                }
                this.showUsage(a, out);
                return 1;
            }
            if (a.startsWith("-log")) {
                ++i;
                continue;
            }
            if ("-baseDir".equals(a)) {
                ++i;
                continue;
            }
            if ("-ifExists".equals(a)) {
                ++i;
                continue;
            }
            this.showUsage(a, out);
            return 1;
        }
        int exitCode = 0;
        if (startDefaultServers) {
            tcpStart = true;
            pgStart = true;
            webStart = true;
            browserStart = true;
        }
        if (tcpShutdown) {
            out.println("Shutting down TCP Server at " + tcpShutdownServer);
            Server.shutdownTcpServer(tcpShutdownServer, tcpPassword, tcpShutdownForce);
        }
        if (tcpStart) {
            this.tcp = Server.createTcpServer(args);
            try {
                this.tcp.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.tcp.getStatus());
        }
        if (pgStart) {
            this.pg = Server.createPgServer(args);
            try {
                this.pg.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.pg.getStatus());
        }
        if (webStart) {
            this.web = Server.createWebServer(args);
            this.web.setShutdownHandler(this);
            try {
                this.web.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.web.getStatus());
            if (browserStart) {
                StartBrowser.openURL(this.web.getURL());
            }
        }
        if (ftpStart) {
            this.ftp = Server.createFtpServer(args);
            try {
                this.ftp.start();
            }
            catch (SQLException e) {
                e.printStackTrace();
                exitCode = 1;
            }
            out.println(this.ftp.getStatus());
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownTcpServer(String url, String password, boolean force) throws SQLException {
        int port = 9092;
        int idx = url.indexOf(58, "jdbc:h2:".length());
        if (idx >= 0) {
            String p = url.substring(idx + 1);
            if ((idx = p.indexOf(47)) >= 0) {
                p = p.substring(0, idx);
            }
            port = MathUtils.decodeInt(p);
        }
        String db = TcpServer.getManagementDbName(port);
        try {
            Driver.load();
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
        for (int i = 0; i < 2; ++i) {
            Connection conn = null;
            PreparedStatement prep = null;
            try {
                block12: {
                    conn = DriverManager.getConnection("jdbc:h2:" + url + "/" + db, "sa", password);
                    prep = conn.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                    prep.setInt(1, port);
                    prep.setString(2, password);
                    prep.setInt(3, force ? 1 : 0);
                    try {
                        prep.execute();
                    }
                    catch (SQLException e) {
                        if (force) break block12;
                        throw e;
                    }
                }
                JdbcUtils.closeSilently(prep);
            }
            catch (SQLException e) {
                if (i != 1) continue;
                throw e;
            }
            finally {
                JdbcUtils.closeSilently(prep);
                JdbcUtils.closeSilently(conn);
            }
            JdbcUtils.closeSilently(conn);
            break;
        }
    }

    String getStatus() {
        StringBuffer buff = new StringBuffer();
        if (this.isRunning()) {
            buff.append(this.service.getType());
            buff.append(" server running on ");
            buff.append(this.service.getURL());
            buff.append(" (");
            if (this.service.getAllowOthers()) {
                buff.append("others can connect");
            } else {
                buff.append("only local connections");
            }
            buff.append(")");
        } else {
            buff.append("Port is in use, maybe another " + this.service.getType() + " server already running on ");
            buff.append(this.service.getURL());
        }
        return buff.toString();
    }

    public static Server createWebServer(String[] args) throws SQLException {
        WebServer service = new WebServer();
        Server server = new Server(service, args);
        service.setShutdownHandler(server);
        return server;
    }

    public static Server createFtpServer(String[] args) throws SQLException {
        return new Server(new FtpServer(), args);
    }

    public static Server createTcpServer(String[] args) throws SQLException {
        return new Server(new TcpServer(), args);
    }

    public static Server createPgServer(String[] args) throws SQLException {
        return new Server(new PgServer(), args);
    }

    public Server start() throws SQLException {
        this.service.start();
        Thread t = new Thread(this);
        t.setName(this.service.getName() + " (" + this.service.getURL() + ")");
        t.start();
        for (int i = 1; i < 64; i += i) {
            Server.wait(i);
            if (!this.isRunning()) continue;
            return this;
        }
        throw Message.getSQLException(90067);
    }

    private static void wait(int i) {
        try {
            long sleep = (long)i * (long)i;
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopAll() {
        if (this.web != null && this.web.isRunning()) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning()) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning()) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.ftp != null && this.ftp.isRunning()) {
            this.ftp.stop();
            this.ftp = null;
        }
    }

    public boolean isRunning() {
        return this.service.isRunning();
    }

    public void stop() {
        this.service.stop();
    }

    public String getURL() {
        return this.service.getURL();
    }

    private Server(Service service, String[] args) throws SQLException {
        this.service = service;
        try {
            service.init(args);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        } else {
            this.stopAll();
        }
    }

    public Service getService() {
        return this.service;
    }
}

