/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.MemoryVisitor;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSinkNode;
import org.drools.reteoo.TupleSource;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;

abstract class BetaNode
extends TupleSource
implements TupleSinkNode,
ObjectSinkNode,
NodeMemory {
    protected final TupleSource leftInput;
    protected final ObjectSource rightInput;
    protected final BetaConstraints constraints;
    private TupleSinkNode previousTupleSinkNode;
    private TupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;

    BetaNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints) {
        super(id);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.constraints = constraints;
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must atleast be an instanceof EmptyBetaCosntraints");
        }
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        LinkedList constraints = this.constraints.getConstraints();
        BetaNodeFieldConstraint[] array = new BetaNodeFieldConstraint[constraints.size()];
        int i = 0;
        for (LinkedListEntry entry = (LinkedListEntry)constraints.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
            array[i++] = (BetaNodeFieldConstraint)entry.getObject();
        }
        return array;
    }

    public void attach() {
        this.leftInput.addTupleSink(this);
        this.rightInput.addObjectSink(this);
    }

    public List getRules() {
        ArrayList<String> list = new ArrayList<String>();
        TupleSink[] sinks = this.sink.getSinks();
        int length = sinks.length;
        for (int i = 0; i < length; ++i) {
            if (sinks[i] instanceof RuleTerminalNode) {
                list.add(((RuleTerminalNode)sinks[i]).getRule().getName());
                continue;
            }
            if (!(sinks[i] instanceof BetaNode)) continue;
            list.addAll(((BetaNode)sinks[i]).getRules());
        }
        return list;
    }

    public ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.objectSource;
        }
        return (ObjectTypeNode)source;
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.leftInput.updateSink(this, propagationContext, workingMemory);
            this.rightInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void remove(BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((TupleSink)((Object)node));
        }
        this.removeShare();
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.rightInput.remove(this, workingMemories);
        this.leftInput.remove(this, workingMemories);
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    public void setObjectMemoryEnabled(boolean objectMemory) {
        this.objectMemory = objectMemory;
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public String toString() {
        return "";
    }

    public void dumpMemory(InternalWorkingMemory workingMemory) {
        MemoryVisitor visitor = new MemoryVisitor(workingMemory);
        visitor.visit(this);
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BetaNode)) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return this.constraints.createBetaMemory(config);
    }

    public TupleSinkNode getNextTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextTupleSinkNode(TupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public TupleSinkNode getPreviousTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousTupleSinkNode(TupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }
}

