/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.transporter.custom.client;

import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.detection.jndi.JNDIDetector;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.samples.transporter.basic.Address;
import org.jboss.remoting.samples.transporter.basic.Customer;
import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
import org.jboss.remoting.samples.transporter.custom.server.SocketServer;
import org.jboss.remoting.transporter.InternalTransporterServices;
import org.jboss.remoting.transporter.TransporterClient;

public class Client {
    private String locatorURI = SocketServer.locatorURI;
    private CustomerProcessor customerProcessor = null;
    static /* synthetic */ Class class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor;

    public void makeClientCall() throws Exception {
        Customer customer = this.createCustomer();
        System.out.println("Customer to be processed: " + customer);
        Customer processedCustomer = this.customerProcessor.processCustomer(customer);
        System.out.println("Customer is now: " + processedCustomer);
    }

    public void getCustomerProcessor() throws Exception {
        this.initTransporterServices();
        this.customerProcessor = (CustomerProcessor)TransporterClient.createTransporterClient(this.locatorURI, class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor == null ? (class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor = Client.class$("org.jboss.remoting.samples.transporter.basic.CustomerProcessor")) : class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor, true);
    }

    private void initTransporterServices() throws Exception {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
        NetworkRegistry registry = NetworkRegistry.getInstance();
        String host = InetAddress.getLocalHost().getHostAddress();
        JNDIDetector jndiDetector = new JNDIDetector();
        jndiDetector.setPort(2410);
        jndiDetector.setHost(host);
        jndiDetector.setContextFactory("org.jnp.interfaces.NamingContextFactory");
        jndiDetector.setURLPackage("org.jboss.naming:org.jnp.interfaces");
        InternalTransporterServices transporterService = InternalTransporterServices.getInstance();
        transporterService.setup(mbeanServer, jndiDetector, new ObjectName("remoting:type=Detector,transport=jndi"), registry, new ObjectName("remoting:type=NetworkRegistry"), true, true);
        jndiDetector.start();
    }

    private Customer createCustomer() {
        Customer cust = new Customer();
        cust.setFirstName("Bob");
        cust.setLastName("Smith");
        Address addr = new Address();
        addr.setStreet("101 Oak Stree");
        addr.setCity("Atlanta");
        addr.setZip(30249);
        cust.setAddr(addr);
        return cust;
    }

    public static void main(String[] args) {
        Client client = new Client();
        try {
            client.getCustomerProcessor();
            while (true) {
                try {
                    while (true) {
                        client.makeClientCall();
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

