/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FONode;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.traits.MinOptMax;

public abstract class BreakingAlgorithm {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$BreakingAlgorithm == null ? (class$org$apache$fop$layoutmgr$BreakingAlgorithm = BreakingAlgorithm.class$("org.apache.fop.layoutmgr.BreakingAlgorithm")) : class$org$apache$fop$layoutmgr$BreakingAlgorithm));
    protected static final int INFINITE_RATIO = 1000;
    private static final int MAX_RECOVERY_ATTEMPTS = 50;
    public static final int ALL_BREAKS = 0;
    public static final int NO_FLAGGED_PENALTIES = 1;
    public static final int ONLY_FORCED_BREAKS = 2;
    private int flaggedPenalty = 50;
    protected int repeatedFlaggedDemerit = 50;
    protected int incompatibleFitnessDemerit = 50;
    protected int maxFlaggedPenaltiesCount;
    private double threshold;
    protected KnuthSequence par;
    protected int lineWidth = -1;
    private boolean force = false;
    protected boolean considerTooShort = false;
    protected KnuthNode lastDeactivatedNode = null;
    private KnuthNode lastTooLong;
    private KnuthNode lastTooShort;
    private KnuthNode lastDeactivated;
    protected int alignment;
    protected int alignmentLast;
    protected boolean bFirst;
    protected KnuthNode[] activeLines;
    protected int activeNodeCount;
    protected int startLine = 0;
    protected int endLine = 0;
    protected int totalWidth;
    protected int totalStretch = 0;
    protected int totalShrink = 0;
    protected BestRecords best;
    private KnuthNode[] positions;
    private boolean partOverflowRecoveryActivated = true;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$BreakingAlgorithm;

    public BreakingAlgorithm(int align, int alignLast, boolean first, boolean partOverflowRecovery, int maxFlagCount) {
        this.alignment = align;
        this.alignmentLast = alignLast;
        this.bFirst = first;
        this.partOverflowRecoveryActivated = partOverflowRecovery;
        this.best = new BestRecords();
        this.maxFlaggedPenaltiesCount = maxFlagCount;
    }

    protected int getMaxRecoveryAttempts() {
        return 50;
    }

    protected boolean isPartOverflowRecoveryActivated() {
        return this.partOverflowRecoveryActivated;
    }

    public abstract void updateData1(int var1, double var2);

    public abstract void updateData2(KnuthNode var1, KnuthSequence var2, int var3);

    public void setConstantLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int findBreakingPoints(KnuthSequence par, double threshold, boolean force, int allowedBreaks) {
        return this.findBreakingPoints(par, 0, threshold, force, allowedBreaks);
    }

    public int findBreakingPoints(KnuthSequence par, int startIndex, double threshold, boolean force, int allowedBreaks) {
        int firstBoxIndex;
        this.par = par;
        this.threshold = threshold;
        this.force = force;
        this.initialize();
        this.activeLines = new KnuthNode[20];
        this.lastTooLong = null;
        this.lastTooShort = null;
        this.endLine = 0;
        this.startLine = 0;
        KnuthElement thisElement = null;
        boolean previousIsBox = false;
        if (this.alignment != 23) {
            for (firstBoxIndex = startIndex; par.size() > firstBoxIndex && !((KnuthElement)par.get(firstBoxIndex)).isBox(); ++firstBoxIndex) {
            }
        }
        this.activeLines = new KnuthNode[20];
        this.addNode(0, this.createNode(firstBoxIndex, 0, 1, 0, 0, 0, 0.0, 0, 0, 0, 0.0, null));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Looping over " + (par.size() - startIndex) + " elements"));
        }
        KnuthNode lastForced = this.getNode(0);
        for (int i = startIndex; i < par.size(); ++i) {
            thisElement = this.getElement(i);
            if (thisElement.isBox()) {
                this.totalWidth += thisElement.getW();
                previousIsBox = true;
                this.handleBox((KnuthBox)thisElement);
            } else if (thisElement.isGlue()) {
                if (previousIsBox && allowedBreaks != 2) {
                    this.considerLegalBreak(thisElement, i);
                }
                this.totalWidth += thisElement.getW();
                this.totalStretch += thisElement.getY();
                this.totalShrink += thisElement.getZ();
                previousIsBox = false;
            } else {
                if (!(((KnuthPenalty)thisElement).getP() >= 1000 || allowedBreaks == 1 && ((KnuthPenalty)thisElement).isFlagged() || allowedBreaks == 2 && ((KnuthPenalty)thisElement).getP() != -1000)) {
                    this.considerLegalBreak(thisElement, i);
                }
                previousIsBox = false;
            }
            if (this.activeNodeCount != 0) continue;
            if (!force) {
                log.debug((Object)("Could not find a set of breaking points " + threshold));
                return 0;
            }
            if (this.lastTooShort == null || lastForced.position == this.lastTooShort.position) {
                if (this.isPartOverflowRecoveryActivated()) {
                    KnuthNode node;
                    lastForced = node = this.createNode(this.lastTooLong.previous.position, this.lastTooLong.previous.line + 1, 1, 0, 0, 0, 0.0, 0, 0, 0, 0.0, this.lastTooLong.previous);
                    node.fitRecoveryCounter = this.lastTooLong.previous.fitRecoveryCounter + 1;
                    log.debug((Object)("first part doesn't fit into line, recovering: " + node.fitRecoveryCounter));
                    if (node.fitRecoveryCounter > this.getMaxRecoveryAttempts()) {
                        FONode contextFO = this.findContextFO(par, node.position + 1);
                        throw new RuntimeException(FONode.decorateWithContextInfo("Some content could not fit into a line/page after " + this.getMaxRecoveryAttempts() + " attempts. Giving up to avoid an endless loop.", contextFO));
                    }
                } else {
                    lastForced = this.lastTooLong;
                }
            } else {
                lastForced = this.lastTooShort;
            }
            log.debug((Object)("Restarting at node " + lastForced));
            i = this.restartFrom(lastForced, i);
        }
        this.finish();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Main loop completed " + this.activeNodeCount));
            log.trace((Object)("Active nodes=" + this.toString("")));
        }
        int line = this.filterActiveNodes();
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthNode node = this.getNode(i);
            while (node != null) {
                this.updateData1(node.line, node.totalDemerits);
                this.calculateBreakPoints(node, par, node.line);
                node = node.next;
            }
        }
        this.activeLines = null;
        return line;
    }

    private FONode findContextFO(KnuthSequence seq, int position) {
        LayoutManager lm;
        ListElement el = seq.getElement(position);
        while (el.getLayoutManager() == null && position < seq.size() - 1) {
            el = seq.getElement(++position);
        }
        Position pos = el != null ? el.getPosition() : null;
        LayoutManager layoutManager = lm = pos != null ? pos.getLM() : null;
        while (pos instanceof NonLeafPosition) {
            if ((pos = ((NonLeafPosition)pos).getPosition()) == null || pos.getLM() == null) continue;
            lm = pos.getLM();
        }
        if (lm != null) {
            return lm.getFObj();
        }
        return null;
    }

    protected void initialize() {
        this.totalWidth = 0;
        this.totalStretch = 0;
        this.totalShrink = 0;
    }

    protected KnuthNode createNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink, double adjustRatio, int availableShrink, int availableStretch, int difference, double totalDemerits, KnuthNode previous) {
        return new KnuthNode(position, line, fitness, totalWidth, totalStretch, totalShrink, adjustRatio, availableShrink, availableStretch, difference, totalDemerits, previous);
    }

    protected KnuthNode createNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink) {
        return new KnuthNode(position, line, fitness, totalWidth, totalStretch, totalShrink, this.best.getAdjust(fitness), this.best.getAvailableShrink(fitness), this.best.getAvailableStretch(fitness), this.best.getDifference(fitness), this.best.getDemerits(fitness), this.best.getNode(fitness));
    }

    protected void handleBox(KnuthBox box) {
    }

    protected int restartFrom(KnuthNode restartingNode, int currentIndex) {
        restartingNode.totalDemerits = 0.0;
        this.addNode(restartingNode.line, restartingNode);
        this.startLine = restartingNode.line;
        this.endLine = this.startLine + 1;
        this.totalWidth = restartingNode.totalWidth;
        this.totalStretch = restartingNode.totalStretch;
        this.totalShrink = restartingNode.totalShrink;
        this.lastTooLong = null;
        this.lastTooShort = null;
        int restartingIndex = restartingNode.position;
        while (restartingIndex + 1 < this.par.size() && !this.getElement(restartingIndex + 1).isBox()) {
            ++restartingIndex;
        }
        return restartingIndex;
    }

    protected void considerLegalBreak(KnuthElement element, int elementIdx) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Feasible breakpoint at " + this.par.indexOf(element) + " " + this.totalWidth + "+" + this.totalStretch + "-" + this.totalShrink));
            log.trace((Object)("\tCurrent active node list: " + this.activeNodeCount + " " + this.toString("\t")));
        }
        this.lastDeactivated = null;
        this.lastTooLong = null;
        for (int line = this.startLine; line < this.endLine; ++line) {
            KnuthNode node = this.getNode(line);
            while (node != null) {
                if (node.position != elementIdx) {
                    double demerits;
                    int fitnessClass;
                    int difference = this.computeDifference(node, element, elementIdx);
                    double r = this.computeAdjustmentRatio(node, difference);
                    int availableShrink = this.totalShrink - node.totalShrink;
                    int availableStretch = this.totalStretch - node.totalStretch;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("\tr=" + r + " difference=" + difference));
                        log.trace((Object)("\tline=" + line));
                    }
                    if (r < -1.0 || element.isForcedBreak()) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Removing " + node));
                        }
                        this.removeNode(line, node);
                        this.lastDeactivated = this.compareNodes(this.lastDeactivated, node);
                    }
                    if (r >= -1.0 && r <= this.threshold) {
                        fitnessClass = this.computeFitness(r);
                        demerits = this.computeDemerits(node, element, fitnessClass, r);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("\tDemerits=" + demerits));
                            log.trace((Object)("\tFitness class=" + fitnessClass));
                        }
                        if (demerits < this.best.getDemerits(fitnessClass)) {
                            this.best.addRecord(demerits, node, r, availableShrink, availableStretch, difference, fitnessClass);
                            this.lastTooShort = null;
                        }
                    }
                    if (this.force && (r <= -1.0 || r > this.threshold)) {
                        KnuthElement tempElement;
                        fitnessClass = this.computeFitness(r);
                        demerits = this.computeDemerits(node, element, fitnessClass, r);
                        int newWidth = this.totalWidth;
                        int newStretch = this.totalStretch;
                        int newShrink = this.totalShrink;
                        for (int i = elementIdx; i < this.par.size() && !(tempElement = this.getElement(i)).isBox(); ++i) {
                            if (tempElement.isGlue()) {
                                newWidth += tempElement.getW();
                                newStretch += tempElement.getY();
                                newShrink += tempElement.getZ();
                                continue;
                            }
                            if (tempElement.isForcedBreak() && i != elementIdx) break;
                        }
                        if (r <= -1.0) {
                            if (this.lastTooLong == null || demerits < this.lastTooLong.totalDemerits) {
                                this.lastTooLong = this.createNode(elementIdx, line + 1, fitnessClass, newWidth, newStretch, newShrink, r, availableShrink, availableStretch, difference, demerits, node);
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Picking tooLong " + this.lastTooLong));
                                }
                            }
                        } else if (this.lastTooShort == null || demerits <= this.lastTooShort.totalDemerits) {
                            if (this.considerTooShort) {
                                this.best.addRecord(demerits, node, r, availableShrink, availableStretch, difference, fitnessClass);
                            }
                            this.lastTooShort = this.createNode(elementIdx, line + 1, fitnessClass, newWidth, newStretch, newShrink, r, availableShrink, availableStretch, difference, demerits, node);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Picking tooShort " + this.lastTooShort));
                            }
                        }
                    }
                }
                node = node.next;
            }
            this.addBreaks(line, elementIdx);
        }
    }

    private void addBreaks(int line, int elementIdx) {
        KnuthElement tempElement;
        if (!this.best.hasRecords()) {
            return;
        }
        int newWidth = this.totalWidth;
        int newStretch = this.totalStretch;
        int newShrink = this.totalShrink;
        for (int i = elementIdx; i < this.par.size() && !(tempElement = this.getElement(i)).isBox(); ++i) {
            if (tempElement.isGlue()) {
                newWidth += tempElement.getW();
                newStretch += tempElement.getY();
                newShrink += tempElement.getZ();
                continue;
            }
            if (tempElement.isForcedBreak() && i != elementIdx) break;
        }
        double minimumDemerits = this.best.getMinDemerits() + (double)this.incompatibleFitnessDemerit;
        for (int i = 0; i <= 3; ++i) {
            if (!this.best.notInfiniteDemerits(i) || !(this.best.getDemerits(i) <= minimumDemerits)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("\tInsert new break in list of " + this.activeNodeCount));
            }
            KnuthNode newNode = this.createNode(elementIdx, line + 1, i, newWidth, newStretch, newShrink);
            this.addNode(line + 1, newNode);
        }
        this.best.reset();
    }

    protected int computeDifference(KnuthNode activeNode, KnuthElement element, int elementIndex) {
        int actualWidth = this.totalWidth - activeNode.totalWidth;
        if (element.isPenalty()) {
            actualWidth += element.getW();
        }
        return this.getLineWidth() - actualWidth;
    }

    protected double computeAdjustmentRatio(KnuthNode activeNode, int difference) {
        if (difference > 0) {
            int maxAdjustment = this.totalStretch - activeNode.totalStretch;
            if (maxAdjustment > 0) {
                return (double)difference / (double)maxAdjustment;
            }
            return 1000.0;
        }
        if (difference < 0) {
            int maxAdjustment = this.totalShrink - activeNode.totalShrink;
            if (maxAdjustment > 0) {
                return (double)difference / (double)maxAdjustment;
            }
            return -1000.0;
        }
        return 0.0;
    }

    private int computeFitness(double r) {
        if (r < -0.5) {
            return 0;
        }
        if (r <= 0.5) {
            return 1;
        }
        if (r <= 1.0) {
            return 2;
        }
        return 3;
    }

    protected double computeDemerits(KnuthNode activeNode, KnuthElement element, int fitnessClass, double r) {
        double demerits = 0.0;
        double f = Math.abs(r);
        f = 1.0 + 100.0 * f * f * f;
        if (element.isPenalty() && element.getP() >= 0) {
            demerits = (f += (double)element.getP()) * f;
        } else if (element.isPenalty() && !element.isForcedBreak()) {
            double penalty = element.getP();
            demerits = f * f - penalty * penalty;
        } else {
            demerits = f * f;
        }
        if (element.isPenalty() && ((KnuthPenalty)element).isFlagged() && this.getElement(activeNode.position).isPenalty() && ((KnuthPenalty)this.getElement(activeNode.position)).isFlagged()) {
            KnuthElement prevElement;
            int flaggedPenaltiesCount;
            demerits += (double)this.repeatedFlaggedDemerit;
            KnuthNode prevNode = activeNode.previous;
            for (flaggedPenaltiesCount = 2; prevNode != null && flaggedPenaltiesCount <= this.maxFlaggedPenaltiesCount && (prevElement = this.getElement(prevNode.position)).isPenalty() && ((KnuthPenalty)prevElement).isFlagged(); ++flaggedPenaltiesCount) {
                prevNode = prevNode.previous;
            }
            if (this.maxFlaggedPenaltiesCount >= 1 && flaggedPenaltiesCount > this.maxFlaggedPenaltiesCount) {
                demerits += Double.POSITIVE_INFINITY;
            }
        }
        if (Math.abs(fitnessClass - activeNode.fitness) > 1) {
            demerits += (double)this.incompatibleFitnessDemerit;
        }
        return demerits += activeNode.totalDemerits;
    }

    protected void finish() {
    }

    protected KnuthElement getElement(int idx) {
        return (KnuthElement)this.par.get(idx);
    }

    protected KnuthNode compareNodes(KnuthNode node1, KnuthNode node2) {
        if (node1 == null || node2.position > node1.position) {
            return node2;
        }
        if (node2.position == node1.position && node2.totalDemerits < node1.totalDemerits) {
            return node2;
        }
        return node1;
    }

    protected void addNode(int line, KnuthNode node) {
        int headIdx = line * 2;
        if (headIdx >= this.activeLines.length) {
            KnuthNode[] oldList = this.activeLines;
            this.activeLines = new KnuthNode[headIdx + headIdx];
            System.arraycopy(oldList, 0, this.activeLines, 0, oldList.length);
        }
        node.next = null;
        if (this.activeLines[headIdx + 1] != null) {
            this.activeLines[headIdx + 1].next = node;
        } else {
            this.activeLines[headIdx] = node;
            this.endLine = line + 1;
        }
        this.activeLines[headIdx + 1] = node;
        ++this.activeNodeCount;
    }

    protected void removeNode(int line, KnuthNode node) {
        KnuthNode n = this.getNode(line);
        if (n != node) {
            log.error((Object)"Should be first");
        } else {
            this.activeLines[line * 2] = node.next;
            if (node.next == null) {
                this.activeLines[line * 2 + 1] = null;
            }
            while (this.startLine < this.endLine && this.getNode(this.startLine) == null) {
                ++this.startLine;
            }
        }
        --this.activeNodeCount;
    }

    protected KnuthNode getNode(int line) {
        return this.activeLines[line * 2];
    }

    private boolean isLegalBreakpoint(int idx) {
        KnuthElement elm = this.getElement(idx);
        if (elm.isPenalty() && elm.getP() != 1000) {
            return true;
        }
        return idx > 0 && elm.isGlue() && this.getElement(idx - 1).isBox();
    }

    public int getDifference(int line) {
        return this.positions[line].difference;
    }

    public double getAdjustRatio(int line) {
        return this.positions[line].adjustRatio;
    }

    public int getStart(int line) {
        KnuthNode previous = this.positions[line].previous;
        return line == 0 ? 0 : previous.position + 1;
    }

    public int getEnd(int line) {
        return this.positions[line].position;
    }

    protected int getLineWidth(int line) {
        if (this.lineWidth < 0) {
            throw new IllegalStateException("lineWidth must be set" + (this.lineWidth != 0 ? " and positive, but it is: " + this.lineWidth : ""));
        }
        return this.lineWidth;
    }

    protected int getLineWidth() {
        return this.lineWidth;
    }

    private static String width(MinOptMax mom) {
        return mom.opt + "+" + (mom.max - mom.opt) + "-" + (mom.opt - mom.min);
    }

    public String toString(String prepend) {
        StringBuffer sb = new StringBuffer();
        sb.append("[\n");
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthNode node = this.getNode(i);
            while (node != null) {
                sb.append(prepend + "\t" + node + ",\n");
                node = node.next;
            }
        }
        sb.append(prepend + "]");
        return sb.toString();
    }

    protected abstract int filterActiveNodes();

    private void calculateBreakPoints(KnuthNode node, KnuthSequence par, int total) {
        KnuthNode bestActiveNode = node;
        for (int i = node.line; i > 0; --i) {
            this.updateData2(bestActiveNode, par, total);
            bestActiveNode = bestActiveNode.previous;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getAlignmentLast() {
        return this.alignmentLast;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class BestRecords {
        private static final double INFINITE_DEMERITS = Double.POSITIVE_INFINITY;
        private double[] bestDemerits = new double[4];
        private KnuthNode[] bestNode = new KnuthNode[4];
        private double[] bestAdjust = new double[4];
        private int[] bestDifference = new int[4];
        private int[] bestAvailableShrink = new int[4];
        private int[] bestAvailableStretch = new int[4];
        private int bestIndex = -1;

        public BestRecords() {
            this.reset();
        }

        public void addRecord(double demerits, KnuthNode node, double adjust, int availableShrink, int availableStretch, int difference, int fitness) {
            if (demerits > this.bestDemerits[fitness]) {
                log.error((Object)"New demerits value greater than the old one");
            }
            this.bestDemerits[fitness] = demerits;
            this.bestNode[fitness] = node;
            this.bestAdjust[fitness] = adjust;
            this.bestAvailableShrink[fitness] = availableShrink;
            this.bestAvailableStretch[fitness] = availableStretch;
            this.bestDifference[fitness] = difference;
            if (this.bestIndex == -1 || demerits < this.bestDemerits[this.bestIndex]) {
                this.bestIndex = fitness;
            }
        }

        public boolean hasRecords() {
            return this.bestIndex != -1;
        }

        public boolean notInfiniteDemerits(int fitness) {
            return this.bestDemerits[fitness] != Double.POSITIVE_INFINITY;
        }

        public double getDemerits(int fitness) {
            return this.bestDemerits[fitness];
        }

        public KnuthNode getNode(int fitness) {
            return this.bestNode[fitness];
        }

        public double getAdjust(int fitness) {
            return this.bestAdjust[fitness];
        }

        public int getAvailableShrink(int fitness) {
            return this.bestAvailableShrink[fitness];
        }

        public int getAvailableStretch(int fitness) {
            return this.bestAvailableStretch[fitness];
        }

        public int getDifference(int fitness) {
            return this.bestDifference[fitness];
        }

        public double getMinDemerits() {
            if (this.bestIndex != -1) {
                return this.getDemerits(this.bestIndex);
            }
            return Double.POSITIVE_INFINITY;
        }

        public void reset() {
            for (int i = 0; i < 4; ++i) {
                this.bestDemerits[i] = Double.POSITIVE_INFINITY;
            }
            this.bestIndex = -1;
        }
    }

    public class KnuthNode {
        public int position;
        public int line;
        public int fitness;
        public int totalWidth;
        public int totalStretch;
        public int totalShrink;
        public double adjustRatio;
        public int availableShrink;
        public int availableStretch;
        public int difference;
        public double totalDemerits;
        public KnuthNode previous;
        public KnuthNode next;
        public int fitRecoveryCounter = 0;

        public KnuthNode(int position, int line, int fitness, int totalWidth, int totalStretch, int totalShrink, double adjustRatio, int availableShrink, int availableStretch, int difference, double totalDemerits, KnuthNode previous) {
            this.position = position;
            this.line = line;
            this.fitness = fitness;
            this.totalWidth = totalWidth;
            this.totalStretch = totalStretch;
            this.totalShrink = totalShrink;
            this.adjustRatio = adjustRatio;
            this.availableShrink = availableShrink;
            this.availableStretch = availableStretch;
            this.difference = difference;
            this.totalDemerits = totalDemerits;
            this.previous = previous;
        }

        public String toString() {
            return "<KnuthNode at " + this.position + " " + this.totalWidth + "+" + this.totalStretch + "-" + this.totalShrink + " line:" + this.line + " prev:" + (this.previous != null ? this.previous.position : -1) + " dem:" + this.totalDemerits + ">";
        }
    }
}

