/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.properties.ColorTypeProperty;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfColorTable;

public class FOPRtfAttributes
extends RtfAttributes {
    public RtfAttributes setTwips(String name, Length value) {
        this.set(name, value.getValue() / 50);
        return this;
    }

    public RtfAttributes setTwips(String name, int value) {
        this.set(name, value / 50);
        return this;
    }

    public RtfAttributes setHalfPoints(String name, Length value) {
        this.set(name, value.getValue() / 500);
        return this;
    }

    public RtfAttributes set(String name, ColorType color) {
        int redComponent = ColorTypeProperty.convertChannelToInteger(color.getRed());
        int greenComponent = ColorTypeProperty.convertChannelToInteger(color.getGreen());
        int blueComponent = ColorTypeProperty.convertChannelToInteger(color.getBlue());
        this.set(name, RtfColorTable.getInstance().getColorNumber(redComponent, greenComponent, blueComponent));
        return this;
    }
}

