/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.mvel.CompileException;
import org.mvel.ExpressionCompiler;
import org.mvel.ParserContext;
import org.mvel.PropertyAccessException;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVerifier
extends AbstractOptimizer {
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private ParserContext parserContext;
    private List<String> inputs = new LinkedList<String>();
    private boolean first = true;
    private boolean resolvedExternally;

    public PropertyVerifier(char[] property, ParserContext parserContext) {
        this.expr = property;
        this.length = property.length;
        this.parserContext = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext) {
        this.expr = property.toCharArray();
        this.length = this.expr.length;
        this.parserContext = parserContext;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public Class analyze() {
        Class ctx = Object.class;
        this.resolvedExternally = true;
        this.first = true;
        while (this.cursor < this.length) {
            switch (this.nextSubToken()) {
                case 0: {
                    ctx = this.getBeanProperty(ctx, this.capture());
                    break;
                }
                case 1: {
                    ctx = this.getMethod(ctx, this.capture());
                    break;
                }
                case 2: {
                    ctx = this.getCollectionProperty();
                    break;
                }
            }
            this.first = false;
        }
        return ctx;
    }

    private Class getBeanProperty(Class ctx, String property) {
        Member member;
        if (this.first) {
            if (this.parserContext.hasVarOrInput(property)) {
                return this.parserContext.getVarOrInputType(property);
            }
            if (this.parserContext.hasImport(property)) {
                this.resolvedExternally = false;
                return this.parserContext.getImport(property);
            }
            return Object.class;
        }
        this.start = this.cursor;
        Member member2 = member = ctx != null ? PropertyTools.getFieldOrAccessor(ctx, property) : null;
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member != null) {
            return ((Method)member).getReturnType();
        }
        if (this.parserContext.hasImport(property)) {
            return this.parserContext.getImport(property);
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                return tryStaticMethodRef.getClass();
            }
            try {
                return ((Field)tryStaticMethodRef).get(null).getClass();
            }
            catch (Exception e) {
                throw new CompileException("in verifier: ", e);
            }
        }
        if (ctx != null && ctx.getClass() == Class.class) {
            for (Method m : ctx.getMethods()) {
                if (!property.equals(m.getName())) continue;
                return m.getReturnType();
            }
        }
        if (this.parserContext.isStrictTypeEnforcement()) {
            this.addFatalError("unqualified type in strict mode for: " + property);
        }
        return Object.class;
    }

    private Class getCollectionProperty() {
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            this.addFatalError("unterminated [ in token");
        }
        ExpressionCompiler compiler = new ExpressionCompiler(new String(this.expr, start, this.cursor - start));
        compiler._compile();
        ++this.cursor;
        return compiler.getReturnType() == null ? Object.class : compiler.getReturnType();
    }

    private Class getMethod(Class ctx, String name) {
        Class[] args;
        if (this.first && this.parserContext.hasImport(name)) {
            Method m = this.parserContext.getStaticImport(name).getMethod();
            ctx = m.getDeclaringClass();
            name = m.getName();
            this.first = false;
        }
        int st = this.cursor;
        this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(');
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() > 0) {
            for (String token : ParseTools.parseParameterList(tk.toCharArray(), 0, -1)) {
                new ExpressionCompiler(token)._compile();
            }
        }
        if (tk.length() == 0) {
            args = new Class[]{};
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            args = new Class[subtokens.length];
            for (int i = 0; i < subtokens.length; ++i) {
                ExpressionCompiler compiler = new ExpressionCompiler(subtokens[i], true);
                compiler._compile();
                args[i] = compiler.getReturnType() != null ? compiler.getReturnType() : Object.class;
            }
        }
        Method m = ParseTools.getBestCandidate(args, name, ctx.getMethods());
        if (m == null && (m = ParseTools.getBestCandidate(args, name, ctx.getDeclaredMethods())) == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name) && args.length == 0 && ctx.isArray()) {
                return Integer.class;
            }
            if (this.parserContext.isStrictTypeEnforcement()) {
                this.addFatalError("unable to resolve method using strict-mode: " + ctx.getName() + "." + name + "(...)");
            }
            return Object.class;
        }
        return m.getReturnType();
    }

    public boolean isResolvedExternally() {
        return this.resolvedExternally;
    }
}

