/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel.CompileException;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.BaseVariableResolverFactory;
import org.mvel.integration.impl.MapVariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, Object> variables;
    private boolean cachingSafe = false;

    public MapVariableResolverFactory(Map<String, Object> variables) {
        this.variables = variables;
    }

    public MapVariableResolverFactory(Map<String, Object> variables, VariableResolverFactory nextFactory) {
        this.variables = variables;
        this.nextFactory = nextFactory;
    }

    public MapVariableResolverFactory(Map<String, Object> variables, boolean cachingSafe) {
        this.variables = variables;
        this.cachingSafe = cachingSafe;
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr != null) {
            vr.setValue(value);
            return vr;
        }
        vr = new MapVariableResolver(this.variables, name, this.cachingSafe);
        vr.setValue(value);
        return vr;
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr != null && vr.getType() != null) {
            throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        vr = new MapVariableResolver(this.variables, name, type, this.cachingSafe);
        this.addResolver(name, vr);
        vr.setValue(value);
        return vr;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.variables.containsKey(name)) {
            return this.variableResolvers != null && this.variableResolvers.containsKey(name) ? (VariableResolver)this.variableResolvers.get(name) : new MapVariableResolver(this.variables, name, this.cachingSafe);
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name);
        }
        return null;
    }

    @Override
    public boolean isResolveable(String name) {
        if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
            return true;
        }
        if (this.variables != null && this.variables.containsKey(name)) {
            return true;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.isResolveable(name);
        }
        return false;
    }

    private void addResolver(String name, VariableResolver vr) {
        if (this.variableResolvers == null) {
            this.variableResolvers = new HashMap();
        }
        this.variableResolvers.put(name, vr);
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    @Override
    public Set<String> getKnownVariables() {
        HashSet<String> knownVars = new HashSet<String>();
        if (this.nextFactory == null) {
            if (this.variables != null) {
                knownVars.addAll(this.variables.keySet());
            }
            return knownVars;
        }
        if (this.variables != null) {
            knownVars.addAll(this.variables.keySet());
        }
        knownVars.addAll(this.nextFactory.getKnownVariables());
        return knownVars;
    }
}

