/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import org.mvel.util.Stack;
import org.mvel.util.StackElement;

public class ExecutionStack
implements Stack {
    private StackElement element;
    private int size = 0;

    public boolean isEmpty() {
        return this.element == null;
    }

    public void add(Object o) {
        ++this.size;
        StackElement el = this.element;
        if (el != null) {
            while (el.next != null) {
                el = el.next;
            }
            el.next = new StackElement(null, o);
        } else {
            this.element = new StackElement(null, o);
        }
    }

    public void push(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
    }

    public Object pushAndPeek(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
        return o;
    }

    public void push(Object obj1, Object obj2) {
        this.size += 2;
        this.element = new StackElement(new StackElement(this.element, obj1), obj2);
    }

    public void push(Object obj1, Object obj2, Object obj3) {
        this.size += 3;
        this.element = new StackElement(new StackElement(new StackElement(this.element, obj1), obj2), obj3);
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.element.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop() {
        if (this.size-- == 0) {
            return null;
        }
        try {
            Object object = this.element.value;
            return object;
        }
        finally {
            this.element = this.element.next;
        }
    }

    public void discard() {
        if (this.size != 0) {
            --this.size;
            this.element = this.element.next;
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.element = null;
    }

    public void showStack() {
        StackElement el = this.element;
        do {
            System.out.println("->" + el.value);
        } while ((el = el.next) != null);
    }
}

