/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.AddConcatExpression;
import freemarker.core.AndExpression;
import freemarker.core.ArithmeticExpression;
import freemarker.core.Assignment;
import freemarker.core.AssignmentInstruction;
import freemarker.core.AttemptBlock;
import freemarker.core.BlockAssignment;
import freemarker.core.BodyInstruction;
import freemarker.core.BooleanLiteral;
import freemarker.core.BreakInstruction;
import freemarker.core.BuiltIn;
import freemarker.core.BuiltinVariable;
import freemarker.core.Case;
import freemarker.core.Comment;
import freemarker.core.ComparisonExpression;
import freemarker.core.CompressedBlock;
import freemarker.core.ConditionalBlock;
import freemarker.core.DollarVariable;
import freemarker.core.Dot;
import freemarker.core.DynamicKeyName;
import freemarker.core.EscapeBlock;
import freemarker.core.Expression;
import freemarker.core.FMParserConstants;
import freemarker.core.FMParserTokenManager;
import freemarker.core.FallbackInstruction;
import freemarker.core.FlushInstruction;
import freemarker.core.HashLiteral;
import freemarker.core.Identifier;
import freemarker.core.IfBlock;
import freemarker.core.Include;
import freemarker.core.IteratorBlock;
import freemarker.core.LibraryLoad;
import freemarker.core.ListLiteral;
import freemarker.core.Macro;
import freemarker.core.MethodCall;
import freemarker.core.MixedContent;
import freemarker.core.NoEscapeBlock;
import freemarker.core.NotExpression;
import freemarker.core.NumberLiteral;
import freemarker.core.NumericalOutput;
import freemarker.core.OrExpression;
import freemarker.core.ParentheticalExpression;
import freemarker.core.ParseException;
import freemarker.core.PropertySetting;
import freemarker.core.Range;
import freemarker.core.RecoveryBlock;
import freemarker.core.RecurseNode;
import freemarker.core.ReturnInstruction;
import freemarker.core.SimpleCharStream;
import freemarker.core.StopInstruction;
import freemarker.core.StringLiteral;
import freemarker.core.SwitchBlock;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.core.TextBlock;
import freemarker.core.Token;
import freemarker.core.TransformBlock;
import freemarker.core.TrimInstruction;
import freemarker.core.UnifiedCall;
import freemarker.core.VisitNode;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.DeepUnwrap;
import freemarker.template.utility.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class FMParser
implements FMParserConstants {
    Template template;
    private String templateName;
    private int loopNesting;
    private int switchNesting;
    private boolean inMacro;
    private boolean inFunction;
    private boolean stripWhitespace;
    private boolean stripText;
    private LinkedList escapes = new LinkedList();
    private int contentNesting;
    public FMParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[76];
    private final int[] jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0x1000000, 0x800000, 0, 0, 114688, 0, 0, 0, 0, 0, 0, 0, 0x180000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30000000, 0, 0, 0, 0, 0, 8192, 0, 2147474752, 0, 0, 0, 2147474752, 2147474752, 0, 0, 2147474752, 0, 0, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0x1800000, 8192, 16384, 0x600000, 983040, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 1475342336, 0, 0, 0, 1475342336, 1475342336, 0, 0, 1475342336, 0, 0, 0, 0, 0};
    private final int[] jj_la1_2 = new int[]{-2143322112, 0, Integer.MIN_VALUE, 0, 0x7F000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x180000, 98304, 0xE00000, 2013659136, 2013659136, 98304, 393216, 0, 0, 0, -2143322112, 0, 0, 0, 0, -2143322112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2143322112, 0, 0, 0, 0, 8, 8, 0, 0, 0, 56, 0, 0, 248, 248, 248, 248, 248, 8, 0, 3, 0, 0};
    private final int[] jj_la1_3 = new int[]{2183169, 256, 1, 50, 0xC000000, 1, 1, 0, 0x200000, 20480, 0x1C0000, 3932166, 0, 0, 2560, 512, 2560, 2183425, 1024, 0, 0, 0x100000, 2183425, 0x100000, 0, 0, 0, 0, 0, 0, 512, 262144, 262144, 0, 0x1040000, 1024, 0x200000, 0, 16384, 0x200000, 8, 0, 512, 32768, 0, 0x10000000, 512, 0x200000, 1024, 0x3000000, 32768, 0x200000, 512, 2183425, 0, 1024, 0x200000, 0x3000000, 0, 0, 0, 0x3000000, 0, 0, -536870912, -536870912, 0, 0, 0, 0, 0, 0, 0x200000, 0, 512, 0x200000};
    private final int[] jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[13];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static FMParser createExpressionParser(String s) {
        SimpleCharStream scs = new SimpleCharStream(new StringReader(s), 1, 1, s.length());
        FMParserTokenManager token_source = new FMParserTokenManager(scs);
        token_source.SwitchTo(2);
        return new FMParser(token_source);
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace) {
        this(reader);
        this.template = template;
        this.token_source.strictEscapeSyntax = strictEscapeSyntax;
        this.token_source.templateName = this.templateName = template != null ? template.getName() : "";
        this.stripWhitespace = stripWhitespace;
    }

    public FMParser(String template) {
        this(null, new StringReader(template), true, true);
    }

    private String getErrorStart(Token t) {
        return "Error in template: " + this.template.getName() + "\non line " + t.beginLine + ", column " + t.beginColumn;
    }

    private void notStringLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof StringLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound string literal: " + exp + "\nExpecting: " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notNumberLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof NumberLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound number literal: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notBooleanLiteral(Expression exp, String expected) throws ParseException {
        if (exp == TemplateBooleanModel.TRUE || exp == TemplateBooleanModel.FALSE) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notHashLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof HashLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound hash literal: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notListLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof ListLiteral) {
            String msg = "Error at: " + exp.getStartLocation() + "\nFound list literal: " + exp + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void numberLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "number");
        this.notListLiteral(exp, "number");
        this.notHashLiteral(exp, "number");
        this.notBooleanLiteral(exp, "number");
    }

    private void stringLiteralOnly(Expression exp) throws ParseException {
        this.notNumberLiteral(exp, "number");
        this.notListLiteral(exp, "number");
        this.notHashLiteral(exp, "number");
        this.notBooleanLiteral(exp, "number");
    }

    private void booleanLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "boolean (true/false)");
        this.notListLiteral(exp, "boolean (true/false)");
        this.notHashLiteral(exp, "boolean (true/false)");
        this.notNumberLiteral(exp, "boolean (true/false)");
    }

    private Expression escapedExpression(Expression exp) {
        if (!this.escapes.isEmpty()) {
            return ((EscapeBlock)this.escapes.getFirst()).doEscape(exp);
        }
        return exp;
    }

    private boolean getBoolean(Expression exp) throws ParseException {
        TemplateModel tm = null;
        try {
            tm = exp.getAsTemplateModel(null);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage() + "\nCould not evaluate expression: " + exp.getCanonicalForm() + exp.getStartLocation(), exp);
        }
        if (tm instanceof TemplateBooleanModel) {
            try {
                return ((TemplateBooleanModel)tm).getAsBoolean();
            }
            catch (TemplateModelException tme) {
                // empty catch block
            }
        }
        if (tm instanceof TemplateScalarModel) {
            try {
                return StringUtil.getYesNo(((TemplateScalarModel)tm).getAsString());
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage() + "\nExpecting yes/no, found: " + exp.getCanonicalForm() + exp.getStartLocation(), exp);
            }
        }
        throw new ParseException("Expecting boolean (yes/no) parameter" + exp.getStartLocation(), exp);
    }

    public final Expression Expression() throws ParseException {
        Expression exp = this.OrExpression();
        return exp;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression PrimaryExpression() throws ParseException {
        void var1_1;
        Expression exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: 
            case 84: 
            case 95: 
            case 96: {
                exp = this.NumberLiteral();
                break;
            }
            case 112: {
                exp = this.HashLiteral();
                break;
            }
            case 79: 
            case 80: {
                exp = this.StringLiteral(true);
                break;
            }
            case 81: 
            case 82: {
                exp = this.BooleanLiteral();
                break;
            }
            case 108: {
                exp = this.ListLiteral();
                break;
            }
            case 117: {
                exp = this.Identifier();
                break;
            }
            case 110: {
                exp = this.Parenthesis();
                break;
            }
            case 85: {
                exp = this.BuiltinVariable();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            exp = this.AddSubExpression(exp);
        }
        return var1_1;
    }

    public final Expression Parenthesis() throws ParseException {
        Token start = this.jj_consume_token(110);
        Expression exp = this.Expression();
        Token end = this.jj_consume_token(111);
        ParentheticalExpression result = new ParentheticalExpression(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Expression UnaryExpression() throws ParseException {
        Expression exp;
        boolean haveNot = false;
        Token t = null;
        Token start = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 104: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            t = this.jj_consume_token(104);
            boolean bl = haveNot = !haveNot;
            if (start != null) continue;
            start = t;
        }
        Expression result = exp = this.PrimaryExpression();
        if (haveNot) {
            this.booleanLiteralOnly(exp);
            result = new NotExpression(exp);
            result.setLocation(this.template, start, (TemplateObject)exp);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression AdditiveExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.MultiplicativeExpression();
        while (this.jj_2_2(Integer.MAX_VALUE)) {
            void var4_4;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    this.jj_consume_token(95);
                    boolean plus = true;
                    break;
                }
                case 96: {
                    this.jj_consume_token(96);
                    boolean plus = false;
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.MultiplicativeExpression();
            if (var4_4 != false) {
                result = new AddConcatExpression(lhs, rhs);
            } else {
                this.numberLiteralOnly(lhs);
                this.numberLiteralOnly(rhs);
                result = new ArithmeticExpression(lhs, rhs, 0);
            }
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression lhs;
        int operation = 1;
        Expression result = lhs = this.UnaryExpression();
        while (this.jj_2_3(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 97: {
                    this.jj_consume_token(97);
                    operation = 1;
                    break;
                }
                case 100: {
                    this.jj_consume_token(100);
                    operation = 2;
                    break;
                }
                case 101: {
                    this.jj_consume_token(101);
                    operation = 3;
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.UnaryExpression();
            this.numberLiteralOnly(lhs);
            this.numberLiteralOnly(rhs);
            result = new ArithmeticExpression(lhs, rhs, operation);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression Comparison() throws ParseException {
        Expression lhs;
        boolean equality = false;
        Expression result = lhs = this.AdditiveExpression();
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            void var4_4;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 90: {
                    Token t = this.jj_consume_token(90);
                    equality = true;
                    break;
                }
                case 88: {
                    Token t = this.jj_consume_token(88);
                    equality = true;
                    break;
                }
                case 89: {
                    Token t = this.jj_consume_token(89);
                    equality = true;
                    break;
                }
                case 123: {
                    Token t = this.jj_consume_token(123);
                    break;
                }
                case 94: {
                    Token t = this.jj_consume_token(94);
                    break;
                }
                case 122: {
                    Token t = this.jj_consume_token(122);
                    break;
                }
                case 93: {
                    Token t = this.jj_consume_token(93);
                    break;
                }
                case 92: {
                    Token t = this.jj_consume_token(92);
                    break;
                }
                case 91: {
                    Token t = this.jj_consume_token(91);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.AdditiveExpression();
            this.notHashLiteral(lhs, "scalar");
            this.notHashLiteral(rhs, "scalar");
            this.notListLiteral(lhs, "scalar");
            this.notListLiteral(rhs, "scalar");
            if (!equality) {
                this.notStringLiteral(lhs, "number");
                this.notStringLiteral(rhs, "number");
            }
            result = new ComparisonExpression(lhs, rhs, var4_4.image);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression AndExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.Comparison();
        while (this.jj_2_5(Integer.MAX_VALUE)) {
            this.jj_consume_token(102);
            Expression rhs = this.Comparison();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new AndExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression OrExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.AndExpression();
        while (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(103);
            Expression rhs = this.AndExpression();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new OrExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final ListLiteral ListLiteral() throws ParseException {
        ArrayList values = new ArrayList();
        Token begin = this.jj_consume_token(108);
        values = this.PositionalArgs();
        Token end = this.jj_consume_token(109);
        ListLiteral result = new ListLiteral(values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression NumberLiteral() throws ParseException {
        void var2_3;
        Token op = null;
        boolean minus = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: 
            case 96: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 95: {
                        op = this.jj_consume_token(95);
                        minus = false;
                        break block0;
                    }
                    case 96: {
                        op = this.jj_consume_token(96);
                        minus = true;
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: {
                Token t = this.jj_consume_token(83);
                break;
            }
            case 84: {
                Token t = this.jj_consume_token(84);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String s = var2_3.image;
        if (minus) {
            s = "-" + s;
        }
        NumberLiteral result = new NumberLiteral(this.template.getArithmeticEngine().toNumber(s));
        Token startToken = op != null ? op : var2_3;
        result.setLocation(this.template, startToken, (Token)var2_3);
        return result;
    }

    public final Range Range(Expression lhs) throws ParseException {
        this.jj_consume_token(86);
        Expression rhs = this.Expression();
        this.numberLiteralOnly(lhs);
        this.numberLiteralOnly(rhs);
        Range range = new Range(lhs, rhs);
        range.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        return range;
    }

    public final Identifier Identifier() throws ParseException {
        Token t = this.jj_consume_token(117);
        Identifier id = new Identifier(t.image);
        id.setLocation(this.template, t, t);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression IdentifierOrStringLiteral() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 117: {
                Expression exp = this.Identifier();
                break;
            }
            case 79: 
            case 80: {
                Expression exp = this.StringLiteral(false);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    public final BuiltinVariable BuiltinVariable() throws ParseException {
        Token dot = this.jj_consume_token(85);
        Token name = this.jj_consume_token(117);
        BuiltinVariable result = null;
        try {
            result = new BuiltinVariable(name.image);
        }
        catch (ParseException pe) {
            pe.lineNumber = dot.beginLine;
            pe.columnNumber = dot.beginColumn;
            throw pe;
        }
        result.setLocation(this.template, dot, name);
        return result;
    }

    public final Expression AddSubExpression(Expression exp) throws ParseException {
        Expression result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                result = this.DotVariable(exp);
                break;
            }
            case 108: {
                result = this.DynamicKey(exp);
                break;
            }
            case 110: {
                result = this.MethodArgs(exp);
                break;
            }
            case 87: {
                result = this.BuiltIn(exp);
                break;
            }
            case 86: {
                result = this.Range(exp);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Expression BuiltIn(Expression exp) throws ParseException {
        Token t = null;
        this.jj_consume_token(87);
        t = this.jj_consume_token(117);
        BuiltIn result = null;
        try {
            result = BuiltIn.newBuiltIn(exp, t.image, t, this.templateName);
        }
        catch (ParseException pe) {
            pe.lineNumber = t.beginLine;
            pe.columnNumber = t.beginColumn;
            throw pe;
        }
        result.setLocation(this.template, (TemplateObject)exp, t);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression DotVariable(Expression exp) throws ParseException {
        void var2_2;
        this.jj_consume_token(85);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 117: {
                Token t = this.jj_consume_token(117);
                break;
            }
            case 97: {
                Token t = this.jj_consume_token(97);
                break;
            }
            case 98: {
                Token t = this.jj_consume_token(98);
                break;
            }
            case 81: 
            case 82: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 114: 
            case 115: 
            case 116: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 91: {
                        t = this.jj_consume_token(91);
                        break;
                    }
                    case 92: {
                        t = this.jj_consume_token(92);
                        break;
                    }
                    case 93: {
                        t = this.jj_consume_token(93);
                        break;
                    }
                    case 94: {
                        t = this.jj_consume_token(94);
                        break;
                    }
                    case 81: {
                        t = this.jj_consume_token(81);
                        break;
                    }
                    case 82: {
                        t = this.jj_consume_token(82);
                        break;
                    }
                    case 114: {
                        t = this.jj_consume_token(114);
                        break;
                    }
                    case 115: {
                        t = this.jj_consume_token(115);
                        break;
                    }
                    case 116: {
                        t = this.jj_consume_token(116);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (Character.isLetter(var2_2.image.charAt(0))) break;
                String msg = this.getErrorStart((Token)var2_2) + "\n" + var2_2.image + " is not a valid identifier.";
                throw new ParseException(msg, var2_2.beginLine, var2_2.beginColumn);
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.notListLiteral(exp, "hash");
        this.notStringLiteral(exp, "hash");
        this.notBooleanLiteral(exp, "hash");
        Dot dot = new Dot(exp, var2_2.image);
        dot.setLocation(this.template, (TemplateObject)exp, (Token)var2_2);
        return dot;
    }

    public final Expression DynamicKey(Expression exp) throws ParseException {
        this.jj_consume_token(108);
        Expression arg = this.Expression();
        Token t = this.jj_consume_token(109);
        this.notBooleanLiteral(exp, "list or hash");
        this.notNumberLiteral(exp, "list or hash");
        DynamicKeyName dkn = new DynamicKeyName(exp, arg);
        dkn.setLocation(this.template, (TemplateObject)exp, t);
        return dkn;
    }

    public final MethodCall MethodArgs(Expression exp) throws ParseException {
        ArrayList args = new ArrayList();
        this.jj_consume_token(110);
        args = this.PositionalArgs();
        Token end = this.jj_consume_token(111);
        args.trimToSize();
        MethodCall result = new MethodCall(exp, args);
        result.setLocation(this.template, (TemplateObject)exp, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final StringLiteral StringLiteral(boolean interpolate) throws ParseException {
        void var2_3;
        boolean raw = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                Token t = this.jj_consume_token(79);
                break;
            }
            case 80: {
                Token t = this.jj_consume_token(80);
                raw = true;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String s = var2_3.image;
        s = s.substring(1, s.length() - 1);
        if (raw) {
            s = s.substring(1);
        } else {
            try {
                s = StringUtil.FTLStringLiteralDec(s);
            }
            catch (ParseException pe) {
                pe.lineNumber = var2_3.beginLine;
                pe.columnNumber = var2_3.beginColumn;
                throw pe;
            }
        }
        StringLiteral result = new StringLiteral(s);
        result.setLocation(this.template, (Token)var2_3, (Token)var2_3);
        if (interpolate && !raw) {
            result.checkInterpolation();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Expression BooleanLiteral() throws ParseException {
        void var1_1;
        void var2_2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                Token t = this.jj_consume_token(81);
                BooleanLiteral result = new BooleanLiteral(false);
                break;
            }
            case 82: {
                Token t = this.jj_consume_token(82);
                BooleanLiteral result = new BooleanLiteral(true);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        var2_2.setLocation(this.template, (Token)var1_1, (Token)var1_1);
        return var2_2;
    }

    public final HashLiteral HashLiteral() throws ParseException {
        ArrayList<Expression> keys = new ArrayList<Expression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        Token begin = this.jj_consume_token(112);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 95: 
            case 96: 
            case 104: 
            case 108: 
            case 110: 
            case 112: 
            case 117: {
                Expression key = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 105: {
                        this.jj_consume_token(105);
                        break;
                    }
                    case 107: {
                        this.jj_consume_token(107);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression value = this.Expression();
                this.stringLiteralOnly(key);
                keys.add(key);
                values.add(value);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 105: {
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(105);
                    key = this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 105: {
                            this.jj_consume_token(105);
                            break;
                        }
                        case 107: {
                            this.jj_consume_token(107);
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    value = this.Expression();
                    this.stringLiteralOnly(key);
                    keys.add(key);
                    values.add(value);
                }
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(113);
        HashLiteral result = new HashLiteral(keys, values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final DollarVariable StringOutput() throws ParseException {
        Token begin = this.jj_consume_token(70);
        Expression exp = this.Expression();
        this.notHashLiteral(exp, "scalar");
        this.notListLiteral(exp, "scalar");
        this.notBooleanLiteral(exp, "scalar");
        Token end = this.jj_consume_token(113);
        DollarVariable result = new DollarVariable(exp, this.escapedExpression(exp));
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final NumericalOutput NumericalOutput() throws ParseException {
        NumericalOutput result;
        Token fmt = null;
        Token begin = this.jj_consume_token(71);
        Expression exp = this.Expression();
        this.numberLiteralOnly(exp);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 106: {
                this.jj_consume_token(106);
                fmt = this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(113);
        if (fmt != null) {
            String msg;
            int minFrac = -1;
            int maxFrac = -1;
            StringTokenizer st = new StringTokenizer(fmt.image, "mM", true);
            int type = 45;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    if (type != 45) {
                        switch (type) {
                            case 109: {
                                if (minFrac != -1) {
                                    throw new ParseException("invalid formatting string", fmt.beginLine, fmt.beginColumn);
                                }
                                minFrac = Integer.parseInt(token);
                                break;
                            }
                            case 77: {
                                if (maxFrac != -1) {
                                    throw new ParseException("invalid formatting string", fmt.beginLine, fmt.beginColumn);
                                }
                                maxFrac = Integer.parseInt(token);
                                break;
                            }
                            default: {
                                throw new ParseException();
                            }
                        }
                        type = 45;
                        continue;
                    }
                    if (token.equals("m")) {
                        type = 109;
                        continue;
                    }
                    if (token.equals("M")) {
                        type = 77;
                        continue;
                    }
                    throw new ParseException();
                }
                catch (ParseException e) {
                    String msg2 = this.getErrorStart(fmt) + "\nInvalid format specifier " + fmt.image;
                    throw new ParseException(msg2, fmt.beginLine, fmt.beginColumn);
                }
                catch (NumberFormatException e) {
                    String msg3 = this.getErrorStart(fmt) + "\nInvalid number in the format specifier " + fmt.image;
                    throw new ParseException(msg3, fmt.beginLine, fmt.beginColumn);
                }
            }
            if (maxFrac == -1) {
                if (minFrac == -1) {
                    msg = this.getErrorStart(fmt) + "\nInvalid format specification, at least one of m and M must be specified!";
                    throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
                }
                maxFrac = minFrac;
            } else if (minFrac == -1) {
                minFrac = 0;
            }
            if (minFrac > maxFrac) {
                msg = this.getErrorStart(fmt) + "\nInvalid format specification, min cannot be greater than max!";
                throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
            }
            if (minFrac > 50 || maxFrac > 50) {
                msg = this.getErrorStart(fmt) + "\nCannot specify more than 50 fraction digits";
                throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
            }
            result = new NumericalOutput(exp, minFrac, maxFrac);
        } else {
            result = new NumericalOutput(exp);
        }
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final TemplateElement If() throws ParseException {
        Token t;
        Token start = this.jj_consume_token(8);
        Expression condition = this.Expression();
        this.jj_consume_token(120);
        TemplateElement block = this.OptionalBlock();
        ConditionalBlock cblock = new ConditionalBlock(condition, block, true);
        cblock.setLocation(this.template, start, (TemplateObject)block);
        IfBlock ifBlock = new IfBlock(cblock);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block6;
                }
            }
            t = this.jj_consume_token(9);
            condition = this.Expression();
            this.LooseDirectiveEnd();
            block = this.OptionalBlock();
            cblock = new ConditionalBlock(condition, block, false);
            cblock.setLocation(this.template, t, (TemplateObject)block);
            ifBlock.addBlock(cblock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                t = this.jj_consume_token(43);
                block = this.OptionalBlock();
                cblock = new ConditionalBlock(null, block, false);
                cblock.setLocation(this.template, t, (TemplateObject)block);
                ifBlock.addBlock(cblock);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(31);
        ifBlock.setLocation(this.template, start, end);
        return ifBlock;
    }

    public final AttemptBlock Attempt() throws ParseException {
        Token start = this.jj_consume_token(6);
        TemplateElement block = this.OptionalBlock();
        RecoveryBlock recoveryBlock = this.Recover();
        Token end = this.jj_consume_token(33);
        AttemptBlock result = new AttemptBlock(block, recoveryBlock);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final RecoveryBlock Recover() throws ParseException {
        Token start = this.jj_consume_token(7);
        TemplateElement block = this.OptionalBlock();
        RecoveryBlock result = new RecoveryBlock(block);
        result.setLocation(this.template, start, (TemplateObject)block);
        return result;
    }

    public final IteratorBlock List() throws ParseException {
        Token start = this.jj_consume_token(10);
        ++this.loopNesting;
        Expression exp = this.Expression();
        this.jj_consume_token(115);
        Token index = this.jj_consume_token(117);
        this.jj_consume_token(120);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(32);
        --this.loopNesting;
        IteratorBlock result = new IteratorBlock(exp, index.image, block, false);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final IteratorBlock ForEach() throws ParseException {
        Token start = this.jj_consume_token(11);
        ++this.loopNesting;
        Token index = this.jj_consume_token(117);
        this.jj_consume_token(114);
        Expression exp = this.Expression();
        this.jj_consume_token(120);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(34);
        --this.loopNesting;
        IteratorBlock result = new IteratorBlock(exp, index.image, block, true);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final VisitNode Visit() throws ParseException {
        Expression namespaces = null;
        Token start = this.jj_consume_token(22);
        Expression targetNode = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 116: {
                this.jj_consume_token(116);
                namespaces = this.Expression();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        Token end = this.LooseDirectiveEnd();
        VisitNode result = new VisitNode(targetNode, namespaces);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final RecurseNode Recurse() throws ParseException {
        void var1_4;
        Token end = null;
        Expression node = null;
        Expression namespaces = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 55: {
                Token start = this.jj_consume_token(55);
                break;
            }
            case 56: {
                Token start = this.jj_consume_token(56);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 95: 
                    case 96: 
                    case 104: 
                    case 108: 
                    case 110: 
                    case 112: 
                    case 117: {
                        node = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 116: {
                        this.jj_consume_token(116);
                        namespaces = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                    }
                }
                end = this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (end == null) {
            end = var1_4;
        }
        RecurseNode result = new RecurseNode(node, namespaces);
        result.setLocation(this.template, (Token)var1_4, end);
        return result;
    }

    public final FallbackInstruction FallBack() throws ParseException {
        Token tok = this.jj_consume_token(57);
        if (!this.inMacro) {
            throw new ParseException(this.getErrorStart(tok) + "\nCannot fall back " + " outside a macro.", tok.beginLine, tok.beginColumn);
        }
        FallbackInstruction result = new FallbackInstruction();
        result.setLocation(this.template, tok, tok);
        return result;
    }

    public final BreakInstruction Break() throws ParseException {
        Token start = this.jj_consume_token(44);
        if (this.loopNesting < 1 && this.switchNesting < 1) {
            String msg = this.getErrorStart(start) + "\n" + start.image + " occurred outside a loop or a switch block.";
            throw new ParseException(msg, start.beginLine, start.beginColumn);
        }
        BreakInstruction result = new BreakInstruction();
        result.setLocation(this.template, start, start);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final ReturnInstruction Return() throws ParseException {
        void var1_3;
        Token end = null;
        Expression exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                Token start;
                end = start = this.jj_consume_token(45);
                break;
            }
            case 24: {
                Token start = this.jj_consume_token(24);
                exp = this.Expression();
                end = this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.inMacro) {
            if (exp != null) {
                String msg = this.getErrorStart((Token)var1_3) + "\nA macro cannot return a value";
                throw new ParseException(msg, var1_3.beginLine, var1_3.beginColumn);
            }
        } else if (this.inFunction) {
            if (exp == null) {
                String msg = this.getErrorStart((Token)var1_3) + "\nA function must return a value";
                throw new ParseException(msg, var1_3.beginLine, var1_3.beginColumn);
            }
        } else if (exp == null) {
            String msg = this.getErrorStart((Token)var1_3) + "\nA return instruction can only occur inside a macro of function";
            throw new ParseException(msg, var1_3.beginLine, var1_3.beginColumn);
        }
        ReturnInstruction result = new ReturnInstruction(exp);
        result.setLocation(this.template, (Token)var1_3, end);
        return result;
    }

    public final StopInstruction Stop() throws ParseException {
        Token start = null;
        Expression exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                start = this.jj_consume_token(46);
                break;
            }
            case 23: {
                start = this.jj_consume_token(23);
                exp = this.Expression();
                this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        StopInstruction result = new StopInstruction(exp);
        result.setLocation(this.template, start, start);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Nested() throws ParseException {
        BodyInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                Token t = this.jj_consume_token(53);
                result = new BodyInstruction(null);
                result.setLocation(this.template, t, t);
                break;
            }
            case 54: {
                Token t = this.jj_consume_token(54);
                ArrayList bodyParameters = this.PositionalArgs();
                Token end = this.LooseDirectiveEnd();
                result = new BodyInstruction(bodyParameters);
                result.setLocation(this.template, t, end);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!this.inMacro) {
            void var1_2;
            throw new ParseException(this.getErrorStart((Token)var1_2) + "\nCannot use a " + var1_2.image + " instruction outside a macro.", var1_2.beginLine, var1_2.beginColumn);
        }
        return result;
    }

    public final TemplateElement Flush() throws ParseException {
        Token t = this.jj_consume_token(47);
        FlushInstruction result = new FlushInstruction();
        result.setLocation(this.template, t, t);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Trim() throws ParseException {
        void var1_2;
        TrimInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                Token t = this.jj_consume_token(48);
                result = new TrimInstruction(true, true);
                break;
            }
            case 49: {
                Token t = this.jj_consume_token(49);
                result = new TrimInstruction(true, false);
                break;
            }
            case 50: {
                Token t = this.jj_consume_token(50);
                result = new TrimInstruction(false, true);
                break;
            }
            case 51: {
                Token t = this.jj_consume_token(51);
                result = new TrimInstruction(false, false);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        result.setLocation(this.template, (Token)var1_2, (Token)var1_2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Assign() throws ParseException {
        Token id = null;
        Expression nsExp = null;
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                Token start = this.jj_consume_token(14);
                int scope = 1;
                break;
            }
            case 15: {
                Token start = this.jj_consume_token(15);
                int scope = 3;
                break;
            }
            case 16: {
                Token start = this.jj_consume_token(16);
                int scope = 2;
                scope = 2;
                if (this.inMacro || this.inFunction) break;
                String msg = this.getErrorStart(start) + "\nLocal variable assigned outside a macro.";
                throw new ParseException(msg, start.beginLine, start.beginColumn);
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Expression nameExp = this.IdentifierOrStringLiteral();
        String varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                void var1_4;
                void var3_5;
                this.jj_consume_token(88);
                Expression exp = this.Expression();
                Assignment ass = new Assignment(varName, exp, (int)var3_5);
                ass.setLocation(this.template, (TemplateObject)nameExp, (TemplateObject)exp);
                assignments.add(ass);
                while (this.jj_2_7(Integer.MAX_VALUE)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 105: {
                            this.jj_consume_token(105);
                            break;
                        }
                        default: {
                            this.jj_la1[30] = this.jj_gen;
                        }
                    }
                    nameExp = this.IdentifierOrStringLiteral();
                    varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
                    this.jj_consume_token(88);
                    exp = this.Expression();
                    ass = new Assignment(varName, exp, (int)var3_5);
                    ass.setLocation(this.template, (TemplateObject)nameExp, (TemplateObject)exp);
                    assignments.add(ass);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 114: {
                        id = this.jj_consume_token(114);
                        nsExp = this.Expression();
                        if (var3_5 == true) break;
                        throw new ParseException(this.getErrorStart(id) + "\nCannot assign to namespace here.", id.beginLine, id.beginColumn);
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                    }
                }
                Token end = this.LooseDirectiveEnd();
                AssignmentInstruction ai = new AssignmentInstruction((int)var3_5);
                for (int i = 0; i < assignments.size(); ++i) {
                    ai.addAssignment((Assignment)assignments.get(i));
                }
                ai.setNamespaceExp(nsExp);
                ai.setLocation(this.template, (Token)var1_4, end);
                return ai;
            }
            case 114: 
            case 120: {
                void var2_13;
                void var1_4;
                void var3_5;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 114: {
                        id = this.jj_consume_token(114);
                        nsExp = this.Expression();
                        if (var3_5 == true) break;
                        throw new ParseException(this.getErrorStart(id) + "\nCannot assign to namespace here.", id.beginLine, id.beginColumn);
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                this.jj_consume_token(120);
                TemplateElement block = this.OptionalBlock();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        Token end = this.jj_consume_token(35);
                        if (var3_5 == 2) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.beginLine, end.beginColumn);
                    }
                    case 37: {
                        Token end = this.jj_consume_token(37);
                        if (var3_5 == true) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.beginLine, end.beginColumn);
                    }
                    case 36: {
                        Token end = this.jj_consume_token(36);
                        if (var3_5 == 3) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags", end.beginLine, end.beginColumn);
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                BlockAssignment ba = new BlockAssignment(block, varName, (int)var3_5, nsExp);
                ba.setLocation(this.template, (Token)var1_4, (Token)var2_13);
                return ba;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Include Include() throws ParseException {
        Expression nameExp;
        Token start;
        Expression encodingExp;
        Expression parseExp;
        block8: {
            Token att;
            parseExp = null;
            encodingExp = null;
            start = this.jj_consume_token(17);
            nameExp = this.Expression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 106: {
                    this.jj_consume_token(106);
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 117: {
                        break;
                    }
                    default: {
                        this.jj_la1[36] = this.jj_gen;
                        break block8;
                    }
                }
                att = this.jj_consume_token(117);
                this.jj_consume_token(88);
                Expression exp = this.Expression();
                String attString = att.image;
                if (attString.equalsIgnoreCase("parse")) {
                    parseExp = exp;
                    continue;
                }
                if (!attString.equalsIgnoreCase("encoding")) break;
                encodingExp = exp;
            }
            String msg = this.getErrorStart(att) + "\nexpecting parse= or encoding= to be specified.";
            throw new ParseException(msg, att.beginLine, att.beginColumn);
        }
        Token end = this.LooseDirectiveEnd();
        Include result = new Include(this.template, nameExp, encodingExp, parseExp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final LibraryLoad Import() throws ParseException {
        Token start = this.jj_consume_token(18);
        Expression nameExp = this.Expression();
        this.jj_consume_token(115);
        Token ns = this.jj_consume_token(117);
        Token end = this.LooseDirectiveEnd();
        LibraryLoad result = new LibraryLoad(this.template, nameExp, ns.image);
        result.setLocation(this.template, start, end);
        this.template.addImport(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Macro Macro() throws ParseException {
        void var3_14;
        void var2_9;
        ArrayList<String> argNames = new ArrayList<String>();
        HashMap<String, Expression> args = new HashMap<String, Expression>();
        ArrayList<String> defNames = new ArrayList<String>();
        Expression defValue = null;
        boolean isFunction = false;
        boolean hasDefaults = false;
        boolean isCatchAll = false;
        String catchAll = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Token start = this.jj_consume_token(20);
                break;
            }
            case 19: {
                Token start = this.jj_consume_token(19);
                isFunction = true;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.inMacro || this.inFunction) {
            throw new ParseException(this.getErrorStart((Token)var2_9) + "\nMacros cannot be nested.", var2_9.beginLine, var2_9.endLine);
        }
        if (isFunction) {
            this.inFunction = true;
        } else {
            this.inMacro = true;
        }
        Expression nameExp = this.IdentifierOrStringLiteral();
        String name = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        block26: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 117: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block26;
                }
            }
            Token arg = this.jj_consume_token(117);
            defValue = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: {
                    this.jj_consume_token(99);
                    isCatchAll = true;
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: {
                    this.jj_consume_token(88);
                    defValue = this.Expression();
                    defNames.add(arg.image);
                    hasDefaults = true;
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 105: {
                    this.jj_consume_token(105);
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                }
            }
            if (catchAll != null) {
                throw new ParseException(this.getErrorStart(arg) + "\nThere may only be one \"catch-all\" parameter in a macro declaration, " + "and it must be the last parameter.", arg.beginLine, arg.endLine);
            }
            if (isCatchAll) {
                if (defValue != null) {
                    throw new ParseException(this.getErrorStart(arg) + "\n\"Catch-all\" macro parameter may not have a default value.", arg.beginLine, arg.endLine);
                }
                catchAll = arg.image;
                continue;
            }
            argNames.add(arg.image);
            if (hasDefaults && defValue == null) {
                throw new ParseException(this.getErrorStart(arg) + "\nIn a macro declaration, parameters without a default value " + "must all occur before the parameters with default values.", arg.beginLine, arg.endLine);
            }
            args.put(arg.image, defValue);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.jj_consume_token(120);
        TemplateElement block = this.OptionalBlock();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                Token end = this.jj_consume_token(39);
                if (!isFunction) break;
                throw new ParseException(this.getErrorStart((Token)var2_9) + "\nExpected function end tag here.", var2_9.beginLine, var2_9.endLine);
            }
            case 38: {
                Token end = this.jj_consume_token(38);
                if (isFunction) break;
                throw new ParseException(this.getErrorStart((Token)var2_9) + "\nExpected macro end tag here.", var2_9.beginLine, var2_9.endLine);
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.inFunction = false;
        this.inMacro = false;
        Macro result = new Macro(name, argNames, args, block);
        result.setCatchAll(catchAll);
        result.isFunction = isFunction;
        result.setLocation(this.template, (Token)var2_9, (Token)var3_14);
        this.template.addMacro(result);
        return result;
    }

    public final CompressedBlock Compress() throws ParseException {
        Token start = this.jj_consume_token(27);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(40);
        CompressedBlock cb = new CompressedBlock(block);
        cb.setLocation(this.template, start, end);
        return cb;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement UnifiedMacroTransform() throws ParseException {
        void var2_9;
        Token start = null;
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        ArrayList<String> bodyParameters = null;
        String directiveName = null;
        TemplateElement nestedBlock = null;
        start = this.jj_consume_token(62);
        Expression exp = this.Expression();
        if (exp instanceof Identifier || exp instanceof Dot && ((Dot)exp).onlyHasIdentifiers()) {
            directiveName = exp.getCanonicalForm();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            positionalArgs = this.PositionalArgs();
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 106: {
                this.jj_consume_token(106);
                bodyParameters = new ArrayList<String>();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 117: {
                        Token t = this.jj_consume_token(117);
                        bodyParameters.add(t.image);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 105: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[46] = this.jj_gen;
                                    break block3;
                                }
                            }
                            this.jj_consume_token(105);
                            t = this.jj_consume_token(117);
                            bodyParameters.add(t.image);
                        }
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                Token end = this.jj_consume_token(121);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                nestedBlock = this.OptionalBlock();
                Token end = this.jj_consume_token(63);
                String s = end.image.substring(3);
                s = s.substring(0, s.length() - 1).trim();
                if (s.length() <= 0 || s.equals(directiveName)) break;
                String msg = this.getErrorStart(end);
                if (directiveName == null) {
                    throw new ParseException(msg + "\nExpecting </@>", end.beginLine, end.beginColumn);
                }
                throw new ParseException(msg + "\nExpecting </@> or </@" + directiveName + ">", end.beginLine, end.beginColumn);
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        UnifiedCall result = positionalArgs != null ? new UnifiedCall(exp, positionalArgs, nestedBlock, bodyParameters) : new UnifiedCall(exp, namedArgs, nestedBlock, bodyParameters);
        result.setLocation(this.template, start, (Token)var2_9);
        return result;
    }

    public final TemplateElement Call() throws ParseException {
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        String macroName = null;
        Token start = this.jj_consume_token(25);
        Token id = this.jj_consume_token(117);
        macroName = id.image;
        if (this.jj_2_10(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            if (this.jj_2_9(Integer.MAX_VALUE)) {
                this.jj_consume_token(110);
            }
            positionalArgs = this.PositionalArgs();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 111: {
                    this.jj_consume_token(111);
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                }
            }
        }
        Token end = this.LooseDirectiveEnd();
        UnifiedCall result = null;
        result = positionalArgs != null ? new UnifiedCall((Expression)new Identifier(macroName), positionalArgs, null, null) : new UnifiedCall((Expression)new Identifier(macroName), namedArgs, null, null);
        result.legacySyntax = true;
        result.setLocation(this.template, start, end);
        return result;
    }

    public final HashMap NamedArgs() throws ParseException {
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        block3: while (true) {
            Token t = this.jj_consume_token(117);
            this.jj_consume_token(88);
            Expression exp = this.Expression();
            result.put(t.image, exp);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 117: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[51] = this.jj_gen;
        return result;
    }

    public final ArrayList PositionalArgs() throws ParseException {
        ArrayList<Expression> result = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 95: 
            case 96: 
            case 104: 
            case 108: 
            case 110: 
            case 112: 
            case 117: {
                Expression arg = this.Expression();
                result.add(arg);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 105: {
                            break;
                        }
                        default: {
                            this.jj_la1[52] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(105);
                    arg = this.Expression();
                    result.add(arg);
                }
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Comment Comment() throws ParseException {
        void var1_2;
        StringBuffer buf = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                Token start = this.jj_consume_token(28);
                break;
            }
            case 29: {
                Token start = this.jj_consume_token(29);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token end = this.UnparsedContent(buf);
        Comment result = new Comment(buf.toString());
        result.setLocation(this.template, (Token)var1_2, end);
        return result;
    }

    public final TextBlock NoParse() throws ParseException {
        StringBuffer buf = new StringBuffer();
        Token start = this.jj_consume_token(30);
        Token end = this.UnparsedContent(buf);
        TextBlock result = new TextBlock(buf.toString(), true);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TransformBlock Transform() throws ParseException {
        void var2_7;
        TemplateElement content = null;
        HashMap<String, Expression> args = null;
        Token start = this.jj_consume_token(21);
        Expression exp = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 117: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block10;
                }
            }
            Token argName = this.jj_consume_token(117);
            this.jj_consume_token(88);
            Expression argExp = this.Expression();
            if (args == null) {
                args = new HashMap<String, Expression>();
            }
            args.put(argName.image, argExp);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 121: {
                Token end = this.jj_consume_token(121);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                content = this.OptionalBlock();
                Token end = this.jj_consume_token(41);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TransformBlock result = new TransformBlock(exp, args, content);
        result.setLocation(this.template, start, (Token)var2_7);
        return result;
    }

    public final SwitchBlock Switch() throws ParseException {
        boolean defaultFound = false;
        Token start = this.jj_consume_token(12);
        Expression switchExp = this.Expression();
        this.jj_consume_token(120);
        ++this.switchNesting;
        SwitchBlock switchBlock = new SwitchBlock(switchExp);
        while (this.jj_2_11(2)) {
            Case caseIns = this.Case();
            if (caseIns.isDefault) {
                if (defaultFound) {
                    String msg = this.getErrorStart(start) + "\nYou can only have one default case in a switch statement";
                    throw new ParseException(msg, start.beginLine, start.beginColumn);
                }
                defaultFound = true;
            }
            switchBlock.addCase(caseIns);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(42);
        --this.switchNesting;
        switchBlock.setLocation(this.template, start, end);
        return switchBlock;
    }

    /*
     * WARNING - void declaration
     */
    public final Case Case() throws ParseException {
        void var4_3;
        Expression exp = null;
        boolean isDefault = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                Token start = this.jj_consume_token(13);
                exp = this.Expression();
                this.jj_consume_token(120);
                break;
            }
            case 52: {
                Token start = this.jj_consume_token(52);
                isDefault = true;
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TemplateElement block = this.OptionalBlock();
        Case result = new Case(exp, block, isDefault);
        result.setLocation(this.template, (Token)var4_3, (TemplateObject)block);
        return result;
    }

    public final EscapeBlock Escape() throws ParseException {
        Token start = this.jj_consume_token(58);
        Token variable = this.jj_consume_token(117);
        this.jj_consume_token(115);
        Expression escapeExpr = this.Expression();
        this.jj_consume_token(120);
        EscapeBlock result = new EscapeBlock(variable.image, escapeExpr, this.escapedExpression(escapeExpr));
        this.escapes.addFirst(result);
        TemplateElement content = this.OptionalBlock();
        result.setContent(content);
        this.escapes.removeFirst();
        Token end = this.jj_consume_token(59);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final NoEscapeBlock NoEscape() throws ParseException {
        Token start = this.jj_consume_token(60);
        if (this.escapes.isEmpty()) {
            String msg = this.getErrorStart(start) + "\nnoescape with no matching escape encountered.";
            throw new ParseException(msg, start.beginLine, start.beginColumn);
        }
        Object escape = this.escapes.removeFirst();
        TemplateElement content = this.OptionalBlock();
        Token end = this.jj_consume_token(61);
        this.escapes.addFirst(escape);
        NoEscapeBlock result = new NoEscapeBlock(content);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Token LooseDirectiveEnd() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 120: {
                Token t = this.jj_consume_token(120);
                break;
            }
            case 121: {
                Token t = this.jj_consume_token(121);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    public final PropertySetting Setting() throws ParseException {
        Token start = this.jj_consume_token(26);
        Token key = this.jj_consume_token(117);
        this.jj_consume_token(88);
        Expression value = this.Expression();
        Token end = this.LooseDirectiveEnd();
        PropertySetting result = new PropertySetting(key.image, value);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement FreemarkerDirective() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                TemplateElement tp = this.If();
                break;
            }
            case 10: {
                TemplateElement tp = this.List();
                break;
            }
            case 11: {
                TemplateElement tp = this.ForEach();
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                TemplateElement tp = this.Assign();
                break;
            }
            case 17: {
                TemplateElement tp = this.Include();
                break;
            }
            case 18: {
                TemplateElement tp = this.Import();
                break;
            }
            case 19: 
            case 20: {
                TemplateElement tp = this.Macro();
                break;
            }
            case 27: {
                TemplateElement tp = this.Compress();
                break;
            }
            case 62: {
                TemplateElement tp = this.UnifiedMacroTransform();
                break;
            }
            case 25: {
                TemplateElement tp = this.Call();
                break;
            }
            case 28: 
            case 29: {
                TemplateElement tp = this.Comment();
                break;
            }
            case 30: {
                TemplateElement tp = this.NoParse();
                break;
            }
            case 21: {
                TemplateElement tp = this.Transform();
                break;
            }
            case 12: {
                TemplateElement tp = this.Switch();
                break;
            }
            case 26: {
                TemplateElement tp = this.Setting();
                break;
            }
            case 44: {
                TemplateElement tp = this.Break();
                break;
            }
            case 24: 
            case 45: {
                TemplateElement tp = this.Return();
                break;
            }
            case 23: 
            case 46: {
                TemplateElement tp = this.Stop();
                break;
            }
            case 47: {
                TemplateElement tp = this.Flush();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                TemplateElement tp = this.Trim();
                break;
            }
            case 53: 
            case 54: {
                TemplateElement tp = this.Nested();
                break;
            }
            case 58: {
                TemplateElement tp = this.Escape();
                break;
            }
            case 60: {
                TemplateElement tp = this.NoEscape();
                break;
            }
            case 22: {
                TemplateElement tp = this.Visit();
                break;
            }
            case 55: 
            case 56: {
                TemplateElement tp = this.Recurse();
                break;
            }
            case 57: {
                TemplateElement tp = this.FallBack();
                break;
            }
            case 6: {
                TemplateElement tp = this.Attempt();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final TextBlock PCData() throws ParseException {
        void var2_3;
        StringBuffer buf = new StringBuffer();
        Token start = null;
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: {
                    Token t = this.jj_consume_token(67);
                    break;
                }
                case 68: {
                    Token t = this.jj_consume_token(68);
                    break;
                }
                case 69: {
                    Token t = this.jj_consume_token(69);
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(var2_3.image);
            if (start != null) continue;
            start = var2_3;
        } while (this.jj_2_12(Integer.MAX_VALUE));
        if (this.stripText && this.contentNesting == 1) {
            return TextBlock.EMPTY_BLOCK;
        }
        TextBlock result = new TextBlock(buf.toString(), false);
        result.setLocation(this.template, start, (Token)var2_3);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final Token UnparsedContent(StringBuffer buf) throws ParseException {
        void var2_2;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 127: {
                    Token t = this.jj_consume_token(127);
                    break;
                }
                case 126: {
                    Token t = this.jj_consume_token(126);
                    break;
                }
                case 125: {
                    Token t = this.jj_consume_token(125);
                    break;
                }
                case 128: {
                    Token t = this.jj_consume_token(128);
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(var2_2.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: 
                case 126: 
                case 127: 
                case 128: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[65] = this.jj_gen;
        buf.setLength(buf.length() - var2_2.image.length());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement Content() throws ParseException {
        void var2_3;
        MixedContent nodes = new MixedContent();
        TemplateObject begin = null;
        ++this.contentNesting;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: 
                case 68: 
                case 69: {
                    TemplateElement elem = this.PCData();
                    break;
                }
                case 70: {
                    TemplateElement elem = this.StringOutput();
                    break;
                }
                case 71: {
                    TemplateElement elem = this.NumericalOutput();
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 60: 
                case 62: {
                    TemplateElement elem = this.FreemarkerDirective();
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = var2_3;
            }
            nodes.addElement((TemplateElement)var2_3);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 60: 
                case 62: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[67] = this.jj_gen;
        --this.contentNesting;
        nodes.setLocation(this.template, begin, (TemplateObject)var2_3);
        return nodes;
    }

    /*
     * WARNING - void declaration
     */
    public final TemplateElement FreeMarkerText() throws ParseException {
        void var2_3;
        MixedContent nodes = new MixedContent();
        TemplateObject begin = null;
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: 
                case 68: 
                case 69: {
                    TemplateElement elem = this.PCData();
                    break;
                }
                case 70: {
                    TemplateElement elem = this.StringOutput();
                    break;
                }
                case 71: {
                    TemplateElement elem = this.NumericalOutput();
                    break;
                }
                default: {
                    this.jj_la1[68] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = var2_3;
            }
            nodes.addElement((TemplateElement)var2_3);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[69] = this.jj_gen;
        nodes.setLocation(this.template, begin, (TemplateObject)var2_3);
        return nodes;
    }

    public final TemplateElement OptionalBlock() throws ParseException {
        TemplateElement tp = TextBlock.EMPTY_BLOCK;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                tp = this.Content();
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
            }
        }
        return tp;
    }

    /*
     * Unable to fully structure code
     */
    public final void HeaderElement() throws ParseException {
        exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                block20: while (true) lbl-1000:
                // 10 sources

                {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 117: {
                            break;
                        }
                        default: {
                            this.jj_la1[72] = this.jj_gen;
                            ** GOTO lbl96
                        }
                    }
                    key = this.jj_consume_token(117);
                    this.jj_consume_token(88);
                    exp = this.Expression();
                    ks = key.image;
                    value = null;
                    try {
                        value = exp.getAsTemplateModel(null);
                    }
                    catch (Exception e) {
                        throw new ParseException("Could not evaluate expression: " + exp.getCanonicalForm() + " " + exp.getStartLocation() + "\nUnderlying cause: " + e.getMessage(), exp);
                    }
                    vs = null;
                    if (value instanceof TemplateScalarModel) {
                        try {
                            vs = ((TemplateScalarModel)exp).getAsString();
                        }
                        catch (TemplateModelException tme) {
                            // empty catch block
                        }
                    }
                    if (this.template == null) continue;
                    if (ks.equalsIgnoreCase("encoding")) {
                        if (vs == null) {
                            throw new ParseException("expecting encoding string here: " + exp.getStartLocation(), exp);
                        }
                        encoding = this.template.getEncoding();
                        if (encoding == null || encoding.equals(vs)) continue;
                        throw new Template.WrongEncodingException(vs);
                    }
                    if (ks.equalsIgnoreCase("STRIP_WHITESPACE")) {
                        this.stripWhitespace = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("STRIP_TEXT")) {
                        this.stripText = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("STRICT_SYNTAX")) {
                        this.token_source.strictEscapeSyntax = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("ns_prefixes")) {
                        if (!(value instanceof TemplateHashModelEx)) {
                            throw new ParseException("Expecting a hash of prefixes to namespace URI's here. " + exp.getStartLocation(), exp);
                        }
                        prefixMap = (TemplateHashModelEx)value;
                        try {
                            keys = prefixMap.keys();
                            it = keys.iterator();
                            while (true) lbl-1000:
                            // 2 sources

                            {
                                if (!it.hasNext()) ** GOTO lbl-1000
                                prefix = ((TemplateScalarModel)it.next()).getAsString();
                                valueModel = prefixMap.get(prefix);
                                if (!(valueModel instanceof TemplateScalarModel)) {
                                    throw new ParseException("Non-string value in prefix to namespace hash. " + exp.getStartLocation(), exp);
                                }
                                nsURI = ((TemplateScalarModel)valueModel).getAsString();
                                try {
                                    this.template.addPrefixNSMapping(prefix, nsURI);
                                    continue;
                                }
                                catch (IllegalArgumentException iae) {
                                    throw new ParseException(iae.getMessage() + " " + exp.getStartLocation(), exp);
                                }
                                break;
                            }
                        }
                        catch (TemplateModelException tme) {}
                        {
                            ** while (true)
                        }
                        continue;
                    }
                    if (!ks.equalsIgnoreCase("attributes")) break;
                    if (!(value instanceof TemplateHashModelEx)) {
                        throw new ParseException("Expecting a hash of attribute names to values here. " + exp.getStartLocation(), exp);
                    }
                    attributeMap = (TemplateHashModelEx)value;
                    try {
                        keys = attributeMap.keys();
                        it = keys.iterator();
                        while (true) {
                            if (!it.hasNext()) continue block20;
                            attName = ((TemplateScalarModel)it.next()).getAsString();
                            attValue = DeepUnwrap.unwrap(attributeMap.get(attName));
                            this.template.setCustomAttribute(attName, attValue);
                        }
                    }
                    catch (TemplateModelException tme) {
                        continue;
                    }
                    break;
                }
                throw new ParseException("Unknown FTL header parameter: " + key.image, key.beginLine, key.beginColumn);
lbl96:
                // 1 sources

                this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Map ParamList() throws ParseException {
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        block6: while (true) {
            Identifier id = this.Identifier();
            this.jj_consume_token(88);
            Expression exp = this.Expression();
            result.put(id.toString(), exp);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 105: {
                    this.jj_consume_token(105);
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 117: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[75] = this.jj_gen;
        return result;
    }

    public final TemplateElement Root() throws ParseException {
        if (this.jj_2_13(Integer.MAX_VALUE)) {
            this.HeaderElement();
        }
        TemplateElement doc = this.OptionalBlock();
        this.jj_consume_token(0);
        doc.setParentRecursively(null);
        return doc.postParseCleanup(this.stripWhitespace);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_11();
        this.jj_save(10, xla);
        return retval;
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_12();
        this.jj_save(11, xla);
        return retval;
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_13();
        this.jj_save(12, xla);
        return retval;
    }

    private final boolean jj_3R_131() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(117)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_168() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_117() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_3R_59()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_105() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_116() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_166() {
        if (this.jj_scan_token(117)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_140() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_139() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_136() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_135() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_115() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_140()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_134() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_134()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_135()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_136()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_171() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_170() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_177() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_176() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_169() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_176()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_177()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_3R_71()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_148() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_3R_70()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_161() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_169()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_170()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_171()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_147() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_3R_69()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_146() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_3R_68()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_145() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_124() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_145()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_146()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_147()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_148()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_64()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_65()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_66()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        Token xsp;
        block3: {
            if (this.jj_3R_61()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_61()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_165() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_123() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(110)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(117)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        if (this.jj_3R_60()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_150() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_114() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_47()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_48()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_104() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_149() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_125() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_149()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_150()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_102()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_103()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_104()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_3R_62()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        Token xsp;
        block3: {
            if (this.jj_3R_73()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_73()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_144() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_143() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_122() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_143()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_144()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        if (this.jj_3R_131()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        if (this.jj_3R_130()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_3R_129()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_3R_128()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(117)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_3R_127()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_3R_126()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_3R_125()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_3R_124()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        if (this.jj_3R_123()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(123)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_3R_122()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(122)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_3R_121()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        if (this.jj_3R_120()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_162() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_34()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_35()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_36()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_37()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_38()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_39()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_40()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_41()) {
                                            return true;
                                        }
                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        if (this.jj_3R_119()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_3R_118()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_142() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_3R_117()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_141() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_116()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_3R_115()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_141()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_142()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_3R_114()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_3R_67()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_3R_113()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_175() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_3R_112()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_174() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_3R_111()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_3R_110()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_164() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_174()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_175()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_3R_109()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_3R_107()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_3R_106()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_3R_105()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_75()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_76()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_77()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_78()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_79()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_80()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_81()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_82()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_83()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_84()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_85()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_86()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_87()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_88()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_89()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_90()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_91()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_92()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_93()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_94()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_95()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_96()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_97()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_98()) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_3R_99()) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_3R_100()) {
                                                                                                                    return true;
                                                                                                                }
                                                                                                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                    return false;
                                                                                                                }
                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                return false;
                                                                                                            }
                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                            return false;
                                                                                                        }
                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                        return false;
                                                                                                    }
                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                    return false;
                                                                                                }
                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                return false;
                                                                                            }
                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                            return false;
                                                                                        }
                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                        return false;
                                                                                    }
                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                    return false;
                                                                                }
                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                return false;
                                                                            }
                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                            return false;
                                                                        }
                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_32()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_120() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_173() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_3R_101()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_172() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_119() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_163() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_172()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_173()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_130() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_51()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_29()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_152() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_151() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_129() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_151()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_152()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_3R_72()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_127() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_138() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_137() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_137()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_138()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_128() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_132() {
        if (this.jj_scan_token(104)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_101() {
        Token xsp;
        block3: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_132()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_3R_133()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_126() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_167() {
        if (this.jj_scan_token(110)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(110)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_24()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_25()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_26()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_27()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_160() {
        if (this.jj_3R_168()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_159() {
        if (this.jj_3R_167()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_158() {
        if (this.jj_3R_166()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_157() {
        if (this.jj_3R_165()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_156() {
        if (this.jj_3R_164()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_155() {
        if (this.jj_3R_163()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_154() {
        if (this.jj_3R_162()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_153() {
        if (this.jj_3R_161()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_45()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_153()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_154()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_155()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_156()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_157()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_158()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_159()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_160()) {
                                        return true;
                                    }
                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_118() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public FMParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 76; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 76; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FMParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 76; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 76; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FMParser(FMParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 76; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(FMParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 76; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[129];
        for (i = 0; i < 129; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 76; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((this.jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((this.jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((this.jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 129; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, FMParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 13; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

