/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.sadun.util.TypeWrapper;

public class ForEach {
    private Iterator i;
    private Filter filter;
    private boolean atStart = true;
    private Object state;

    public ForEach(Collection collection, Filter filter) {
        this(collection.iterator(), filter);
    }

    public ForEach(Collection collection) {
        this(collection, null);
    }

    public ForEach(Object[] objectArray, Filter filter) {
        this(Arrays.asList(objectArray), filter);
    }

    public ForEach(Object[] objectArray) {
        this(objectArray, null);
    }

    public ForEach(Iterator iterator, Filter filter) {
        if (iterator == null) {
            throw new IllegalArgumentException("Collection can't be 'null'");
        }
        if (filter == null) {
            filter = new NullFilter();
        }
        this.i = iterator;
        this.filter = filter;
    }

    public ForEach(Iterator iterator) {
        this(iterator, null);
    }

    public void setState(Object object) {
        this.state = object;
    }

    public void setState(int n) {
        this.state = new Integer(n);
    }

    public void setState(byte by) {
        this.state = new Byte(by);
    }

    public void setState(char c) {
        this.state = new Character(c);
    }

    public void setState(long l) {
        this.state = new Long(l);
    }

    public void setState(float f) {
        this.state = new Float(f);
    }

    public void setState(double d) {
        this.state = new Double(d);
    }

    public void setState(boolean bl) {
        this.state = new Boolean(bl);
    }

    public Object execute() {
        if (!this.atStart) {
            throw new IllegalStateException("execute() already invoked: use reInit() before reinvoking");
        }
        while (this.i.hasNext()) {
            Object e = this.i.next();
            if (!this.filter.accept(e)) continue;
            this.action(e);
        }
        this.atStart = false;
        return this.state;
    }

    public byte executeByte() {
        this.execute();
        if (this.state == null) {
            return 0;
        }
        return (Byte)TypeWrapper.convertValue(this.state, Byte.TYPE);
    }

    public int executeInt() {
        this.execute();
        if (this.state == null) {
            return 0;
        }
        return (Integer)TypeWrapper.convertValue(this.state, Integer.TYPE);
    }

    public short executeShort() {
        this.execute();
        if (this.state == null) {
            return 0;
        }
        return (Short)TypeWrapper.convertValue(this.state, Short.TYPE);
    }

    public long executeLong() {
        this.execute();
        if (this.state == null) {
            return 0L;
        }
        return (Long)TypeWrapper.convertValue(this.state, Long.TYPE);
    }

    public char executeChar() {
        this.execute();
        if (this.state == null) {
            return '\u0000';
        }
        return ((Character)TypeWrapper.convertValue(this.state, Character.TYPE)).charValue();
    }

    public boolean executeBoolean() {
        this.execute();
        if (this.state == null) {
            return false;
        }
        return (Boolean)TypeWrapper.convertValue(this.state, Boolean.TYPE);
    }

    public float executeFloat() {
        this.execute();
        if (this.state == null) {
            return 0.0f;
        }
        return ((Float)TypeWrapper.convertValue(this.state, Float.TYPE)).floatValue();
    }

    public double executeDouble() {
        this.execute();
        if (this.state == null) {
            return 0.0;
        }
        return (Double)TypeWrapper.convertValue(this.state, Double.TYPE);
    }

    public String executeString() {
        this.execute();
        if (this.state == null) {
            return null;
        }
        return (String)TypeWrapper.convertValue(this.state, String.class);
    }

    public void reInit(Collection collection) {
        this.reInit(collection.iterator());
    }

    public void reInit(Iterator iterator) {
        this.i = iterator;
        this.atStart = true;
    }

    public void action(Object object) {
        System.out.println(object);
    }

    private static class NullFilter
    implements Filter {
        private NullFilter() {
        }

        public boolean accept(Object object) {
            return true;
        }
    }

    public static interface Filter {
        public boolean accept(Object var1);
    }
}

