/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class IndentedPrintWriter
extends PrintWriter {
    private static char[] ls = System.getProperty("line.separator").toCharArray();
    private int truncatedNL = 0;
    private char[] spc;
    private boolean start = true;
    private char indentationChar = (char)32;
    private boolean autoFlush;

    public IndentedPrintWriter(Writer writer, int n) {
        this(writer, n, false);
    }

    public IndentedPrintWriter(OutputStream outputStream, int n, boolean bl) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), n, bl);
    }

    public IndentedPrintWriter(OutputStream outputStream, int n) {
        this(outputStream, n, false);
    }

    public IndentedPrintWriter(Writer writer, int n, boolean bl) {
        super(writer, bl);
        this.autoFlush = bl;
        this.setIndentation(n);
    }

    public IndentedPrintWriter(Writer writer) {
        this(writer, 0);
    }

    public IndentedPrintWriter(OutputStream outputStream, boolean bl) {
        this(outputStream, 0, bl);
    }

    public IndentedPrintWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public IndentedPrintWriter(Writer writer, boolean bl) {
        this(writer, 0, bl);
    }

    public int getIndentation() {
        return this.spc.length;
    }

    public synchronized void setIndentation(int n) {
        if (n < 0) {
            throw new RuntimeException("Attmpting to set negative indentation");
        }
        this.spc = new char[n];
        Arrays.fill(this.spc, this.indentationChar);
    }

    public void incIndentation(int n) {
        this.setIndentation(this.getIndentation() + n);
    }

    public void decIndentation(int n) {
        this.setIndentation(this.getIndentation() - n);
    }

    public void incIndentation() {
        this.incIndentation(1);
    }

    public void decIndentation() {
        this.decIndentation(1);
    }

    public synchronized void setIndentationChar(char c) {
        this.indentationChar = c;
        this.setIndentation(this.getIndentation());
    }

    public char getIndentationChar() {
        return this.indentationChar;
    }

    public void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    public void write(int n) {
        this.write(new char[]{(char)n}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Writer writer = this.out;
        synchronized (writer) {
            int n3;
            if (this.start) {
                super.write(this.spc, 0, this.spc.length);
                this.start = false;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n4 = this.truncatedNL;
            for (n3 = n; n3 < n + n2; ++n3) {
                if (!this.isNL(cArray, n3, n + n2)) continue;
                arrayList.add(new Integer(n3));
            }
            n3 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                super.write(cArray, n3, n5 - n3);
                super.write(ls, 0, ls.length);
                super.write(this.spc, 0, this.spc.length);
                n3 = n5 + ls.length - n4;
                if (n4 == 0) continue;
                n4 = 0;
            }
            super.write(cArray, n3, n + n2 - n3);
            if (this.autoFlush) {
                super.flush();
            }
        }
    }

    private boolean isNL(char[] cArray, int n, int n2) {
        for (int i = this.truncatedNL; i < ls.length && n + i < n2; ++i) {
            int n3 = n + i - this.truncatedNL;
            if (cArray[n3] == ls[i]) continue;
            if (this.truncatedNL != 0) {
                this.truncatedNL = 0;
            }
            return false;
        }
        if (n2 - n + this.truncatedNL < ls.length) {
            this.truncatedNL = n2 - n;
            return false;
        }
        if (this.truncatedNL != 0) {
            this.truncatedNL = 0;
        }
        return true;
    }

    public void println() {
        super.println();
        this.flush();
        this.start = true;
    }
}

