/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JustifierWriter
extends FilterWriter {
    private int lineLength = 80;
    private StringBuffer buffer = new StringBuffer();
    private static String lineSep = System.getProperty("line.separator");
    private boolean justifyOnNewLine = false;
    private boolean preserveInitialSpaces = false;
    private boolean autoFlush = false;
    private boolean padOnNewLine = false;
    private boolean atStart = true;
    private List words = new ArrayList();
    private StringBuffer lastWordPiece = new StringBuffer();

    public JustifierWriter(Writer writer) {
        this(writer, 80);
    }

    public JustifierWriter(Writer writer, int n) {
        super(writer);
        this.lineLength = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.addWords(cArray, n, n2);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    private void addWords(char[] cArray, int n, int n2) throws IOException {
        this.findWords(cArray, n, n2);
        Iterator iterator = this.words.iterator();
        while (iterator.hasNext()) {
            WordInfo wordInfo = (WordInfo)iterator.next();
            iterator.remove();
            if (this.isLineSep(wordInfo.cs, wordInfo.start)) {
                this.outputBuffer(this.justifyOnNewLine);
                continue;
            }
            if (this.buffer.length() + 1 + wordInfo.length > this.lineLength && this.buffer.length() > 0) {
                this.outputBuffer(true);
            }
            if (this.buffer.length() > 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(wordInfo.cs, wordInfo.start, wordInfo.length);
            if (!this.atStart) continue;
            this.atStart = false;
        }
    }

    private void outputBuffer(boolean bl) throws IOException {
        if (bl) {
            this.buffer = JustifierWriter.justify(this.buffer, this.lineLength, this.preserveInitialSpaces);
        }
        if (this.padOnNewLine) {
            int n = this.lineLength - this.buffer.length();
            for (int i = 0; i < n; ++i) {
                this.buffer.append(' ');
            }
        }
        this.out.write(this.buffer.toString());
        this.out.write(lineSep);
        this.atStart = true;
        if (this.autoFlush) {
            this.out.flush();
        }
        this.buffer.delete(0, this.buffer.length());
    }

    private void findWords(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        boolean bl = this.lastWordPiece.length() > 0;
        int n4 = n;
        for (int i = n; i < n3; ++i) {
            if (Character.isSpace(cArray[i])) {
                if (bl) {
                    this.completeWord(cArray, n4, i);
                } else if (this.atStart && this.preserveInitialSpaces) {
                    int n5;
                    for (n5 = i; n5 < n3 && Character.isSpace(cArray[n5]); ++n5) {
                    }
                    this.addWord(cArray, n4, n5);
                    i = n5 - 1;
                }
                bl = false;
                if (!this.isLineSep(cArray, i)) continue;
                this.addWord(lineSep.toCharArray(), 0, 2);
                continue;
            }
            if (!bl) {
                bl = true;
                n4 = i;
                continue;
            }
            if (this.lastWordPiece.length() + i - n4 != this.lineLength) continue;
            this.completeWord(cArray, n4, i);
            n4 = i;
            this.addWord(lineSep.toCharArray(), 0, 2);
        }
        if (bl && n4 != n3) {
            this.lastWordPiece.append(cArray, n4, n3 - n4);
        }
    }

    private void completeWord(char[] cArray, int n, int n2) {
        if (this.lastWordPiece.length() > 0) {
            this.lastWordPiece.append(cArray, n, n2 - n);
            this.addWord(this.lastWordPiece.toString().toCharArray(), 0, this.lastWordPiece.length());
            this.lastWordPiece.delete(0, this.lastWordPiece.length());
        } else {
            this.addWord(cArray, n, n2 - n);
        }
    }

    private void addWord(char[] cArray, int n, int n2) {
        this.words.add(new WordInfo(cArray, n, n2));
    }

    private boolean isLineSep(char[] cArray, int n) {
        for (int i = 0; i < lineSep.length(); ++i) {
            if (i >= cArray.length) {
                return false;
            }
            if (cArray[n + i] == lineSep.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String justify(String string, int n) {
        return JustifierWriter.justify(new StringBuffer(string), n, false).toString();
    }

    public static String justify(String string, int n, boolean bl) {
        return JustifierWriter.justify(new StringBuffer(string), n, bl).toString();
    }

    private static StringBuffer justify(StringBuffer stringBuffer, int n) {
        return JustifierWriter.justify(stringBuffer, n, false);
    }

    private static StringBuffer justify(StringBuffer stringBuffer, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = new String[]{};
        int n5 = 0;
        if (bl) {
            for (n4 = 0; n4 < stringBuffer.length(); ++n4) {
                if (Character.isSpace(stringBuffer.charAt(n4))) continue;
                n5 = n4 - 1;
                stringArray = stringBuffer.substring(n4).split(" ");
                break;
            }
        } else {
            stringArray = stringBuffer.toString().split(" ");
        }
        if (stringArray.length == 0) {
            return stringBuffer;
        }
        n4 = n;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 -= stringArray[n3].length();
        }
        if (bl && n5 > 0) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (!Character.isSpace(stringBuffer.charAt(n3))) continue;
                stringBuffer2.append(' ');
            }
            n4 -= n5;
        }
        double d = (double)n4 / (double)(stringArray.length - 1);
        double d2 = 0.0;
        double d3 = 0.0;
        for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
            stringBuffer2.append(stringArray[n2]);
            d2 += d;
            if (!(d2 - d3 >= 1.0)) continue;
            int n6 = (int)(d2 - d3);
            for (int i = 0; i < n6; ++i) {
                stringBuffer2.append(' ');
            }
            n4 -= n6;
            d3 += (double)n6;
        }
        if (stringArray.length > 1) {
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuffer2.append(' ');
            }
        }
        stringBuffer2.append(stringArray[stringArray.length - 1]);
        return stringBuffer2;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int n) {
        this.lineLength = n;
    }

    public boolean isJustifyOnNewLine() {
        return this.justifyOnNewLine;
    }

    public void setJustifyOnNewLine(boolean bl) {
        this.justifyOnNewLine = bl;
    }

    public boolean isPreserveInitialSpaces() {
        return this.preserveInitialSpaces;
    }

    public void setPreserveInitialSpaces(boolean bl) {
        this.preserveInitialSpaces = bl;
    }

    public boolean isPadOnNewLine() {
        return this.padOnNewLine;
    }

    public void setPadOnNewLine(boolean bl) {
        this.padOnNewLine = bl;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean bl) {
        this.autoFlush = bl;
    }

    public static void main(String[] stringArray) {
        StringWriter stringWriter = new StringWriter();
        JustifierWriter justifierWriter = new JustifierWriter(stringWriter);
        justifierWriter.setLineLength(20);
        PrintWriter printWriter = new PrintWriter(justifierWriter);
        while (true) {
            printWriter.println("Nel mezzo del cammin di nostra vita mi ritrovai per una selva oscura che la diretta via era smarrita.");
            System.out.println(stringWriter.toString());
        }
    }

    static class WordInfo {
        char[] cs;
        int start;
        int length;

        WordInfo(char[] cArray, int n, int n2) {
            this.cs = cArray;
            this.start = n;
            this.length = n2;
        }

        public String toString() {
            throw new RuntimeException();
        }
    }
}

