/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ListMapIterator
implements Iterator {
    Map map;
    Iterator currentKeyIterator;
    Iterator currentListIterator;
    Object currentKey;
    boolean failOnUnknownKeys;
    boolean requireUniqueKeys;

    private static List getDefaultOrderingList(Map map) {
        Set set = map.keySet();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public ListMapIterator(Map map) {
        this(map, ListMapIterator.getDefaultOrderingList(map));
    }

    public ListMapIterator(Map map, List list) {
        this(map, list, true, false);
    }

    public ListMapIterator(Map map, List list, boolean bl, boolean bl2) {
        this.map = map;
        this.failOnUnknownKeys = bl;
        if (bl2) {
            HashSet hashSet = new HashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
            if (hashSet.size() != list.size()) {
                throw new IllegalArgumentException("ordering list must contain distinct keys");
            }
        }
        this.currentKeyIterator = list.iterator();
        this.goToNextKey();
    }

    private boolean goToNextKey() {
        if (this.currentKeyIterator.hasNext()) {
            try {
                this.currentKey = this.currentKeyIterator.next();
                List list = (List)this.map.get(this.currentKey);
                if (list == null) {
                    if (this.failOnUnknownKeys) {
                        throw new IllegalArgumentException("The key <" + this.currentKey.toString() + "> is not found in the map");
                    }
                    return this.goToNextKey();
                }
                this.currentListIterator = list.iterator();
                return true;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("The passed map does not contain a List");
            }
        }
        return false;
    }

    public boolean hasNext() {
        if (this.currentListIterator != null) {
            if (this.currentListIterator.hasNext()) {
                return true;
            }
            if (!this.goToNextKey()) {
                return false;
            }
            return this.hasNext();
        }
        return false;
    }

    public Object next() {
        if (this.currentListIterator == null) {
            throw new NoSuchElementException();
        }
        return this.currentListIterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    public static void main(String[] stringArray) throws Exception {
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("hello");
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("world");
        arrayList3.add(",");
        arrayList3.add("how");
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList4.add("is it?");
        hashMap.put("step1", arrayList);
        hashMap.put("step2", arrayList2);
        hashMap.put("step3", arrayList3);
        hashMap.put("step4", arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>();
        arrayList5.add("step1");
        arrayList5.add("step2");
        arrayList5.add("step3");
        arrayList5.add("step4");
        ListMapIterator listMapIterator = new ListMapIterator(hashMap, arrayList5);
        while (listMapIterator.hasNext()) {
            System.out.print(listMapIterator.next());
            System.out.print(" ");
        }
    }

    public Object getCurrentKey() {
        return this.currentKey;
    }
}

