/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class QuoteAwareStringTokenizer
implements Enumeration {
    private String str;
    private String delim;
    private String quotePairs;
    private boolean returnDelims;
    private char[][] quotes;
    private static String DEFAULT_QUOTEPAIRS = "\"\"''";
    private Object[][] entries;
    private int currEntryIndex;

    public QuoteAwareStringTokenizer(String string, String string2, String string3, boolean bl) {
        this.str = string;
        this.returnDelims = bl;
        this.init(string2, string3);
        this.tokenize();
    }

    private void init(String string, String string2) {
        this.delim = string;
        this.quotePairs = string2;
        if (string2.length() % 2 != 0) {
            throw new IllegalArgumentException("Please specify quotes in pairs (e.g. \"\\\"\\\"''()\")");
        }
        this.quotes = new char[string2.length() / 2][2];
        for (int i = 0; i < string2.length() / 2; ++i) {
            this.quotes[i][0] = string2.charAt(i * 2);
            this.quotes[i][1] = string2.charAt(i * 2 + 1);
            if (string.indexOf(this.quotes[i][0]) != -1) {
                throw new IllegalArgumentException("'" + this.quotes[i][0] + "' cannot be used as a delimiter since it has been passed as a quote character");
            }
            if (string.indexOf(this.quotes[i][1]) == -1) continue;
            throw new IllegalArgumentException("'" + this.quotes[i][1] + "' cannot be used as a delimiter since it has been passed as a quote character");
        }
    }

    private void tokenize() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.str.length()) {
            char c = this.str.charAt(n3);
            if (n == -1) {
                int n4 = this.delim.indexOf(c);
                if (n4 != -1) {
                    Object[] objectArray;
                    if (n2 != n3) {
                        objectArray = new Object[]{this.str.substring(n2, n3), new Integer(n2)};
                        arrayList.add(objectArray);
                    }
                    do {
                        if (!this.returnDelims) continue;
                        objectArray = new Object[]{this.delim.substring(n4, n4 + 1), new Integer(n3)};
                        arrayList.add(objectArray);
                    } while (++n3 < this.str.length() && (n4 = this.delim.indexOf(this.str.charAt(n3))) != -1);
                    n2 = n3;
                    continue;
                }
                for (int i = 0; i < this.quotes.length; ++i) {
                    if (c != this.quotes[i][0]) continue;
                    if (n3 > 1 && this.str.charAt(n3 - 1) == '\\') break;
                    n = i;
                    if (n2 != n3) {
                        Object[] objectArray = new Object[]{this.str.substring(n2, n3), new Integer(n2)};
                        arrayList.add(objectArray);
                    }
                    n2 = n3 + 1;
                    break;
                }
                ++n3;
                continue;
            }
            if (c == this.quotes[n][1] && (n3 <= 1 || this.str.charAt(n3 - 1) != '\\')) {
                Object[] objectArray = new Object[]{this.str.substring(n2, n3), new Integer(n2)};
                arrayList.add(objectArray);
                n = -1;
                n2 = n3 + 1;
            }
            ++n3;
        }
        if (n != -1) {
            throw new NoSuchElementException("Unterminated quotation (started with '" + this.quotes[n][0] + "', expected '" + this.quotes[n][1] + "')");
        }
        if (n2 < this.str.length()) {
            Object[] objectArray = new Object[]{this.str.substring(n2, this.str.length()), new Integer(n2)};
            arrayList.add(objectArray);
        }
        this.entries = new Object[arrayList.size()][2];
        arrayList.toArray((T[])this.entries);
        for (n3 = 0; n3 < this.entries.length; ++n3) {
            this.entries[n3][0] = this.unescapeQuotes((String)this.entries[n3][0]);
        }
    }

    private String unescapeQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() - 1) {
                char c2 = string.charAt(i + 1);
                boolean bl = false;
                for (int j = 0; j < this.quotes.length; ++j) {
                    if (c2 != this.quotes[j][0] && c2 != this.quotes[j][1]) continue;
                    stringBuffer.append(c2);
                    bl = true;
                    ++i;
                    break;
                }
                if (bl) continue;
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public QuoteAwareStringTokenizer(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public QuoteAwareStringTokenizer(String string, String string2, boolean bl) {
        this(string, string2, DEFAULT_QUOTEPAIRS, bl);
    }

    public QuoteAwareStringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public QuoteAwareStringTokenizer(String string) {
        this(string, " ");
    }

    public int countTokens() {
        return this.entries.length - this.currEntryIndex;
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException("No more tokens");
        }
        return (String)this.entries[this.currEntryIndex++][0];
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.currEntryIndex < this.entries.length;
    }

    public String nextToken(String string, String string2) {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException("No more tokens");
        }
        int n = (Integer)this.entries[this.currEntryIndex][1];
        this.str = this.str.substring(n);
        this.init(string, string2);
        this.tokenize();
        this.currEntryIndex = 0;
        return this.nextToken();
    }

    public String nextToken(String string) {
        return this.nextToken(string, this.quotePairs);
    }
}

