/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sadun.util.IdIterator;
import org.sadun.util.pool.connection.ConnectionPool;

public class SqlIdIterator
implements IdIterator {
    private ConnectionPool connectionPool;
    private Connection conn;
    private Statement stmt;
    private ResultSet rs;
    private String current;
    private String previous;
    private String next;

    public SqlIdIterator(ConnectionPool connectionPool, String string, String string2) throws SQLException {
        this(connectionPool, string, string2, null, null);
    }

    public SqlIdIterator(ConnectionPool connectionPool, String string, String string2, String string3, String string4) throws SQLException {
        this.connectionPool = connectionPool;
        this.conn = connectionPool.getConnection();
        this.init(string, string2, string3, string4);
    }

    public SqlIdIterator(Connection connection, String string, String string2) throws SQLException {
        this(connection, string, string2, null, null);
    }

    public SqlIdIterator(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        this.conn = connection;
        this.init(string, string2, string3, string4);
    }

    private void init(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "select " + string2 + " from " + string;
        int n = (string3 == null ? 0 : 1) + (string4 == null ? 0 : 1);
        if (n > 0) {
            string5 = string5 + " where ";
            if (string3 != null) {
                string5 = string5 + " " + string2 + " less than " + SqlIdIterator.toSqlString(string3);
            }
            if (string4 != null) {
                if (string3 != null) {
                    string5 = string5 + " and ";
                }
                string5 = string5 + " " + string2 + " greater than " + SqlIdIterator.toSqlString(string4);
            }
        }
        try {
            this.stmt = this.conn.createStatement(1004, 1007);
            this.rs = this.stmt.executeQuery(string5);
            if (this.rs.next()) {
                this.current = this.rs.getString(1);
            }
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toSqlString(String string) {
        StringBuffer stringBuffer;
        int n = string.indexOf(39);
        if (n == -1) {
            return string;
        }
        int n2 = 0;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
        synchronized (stringBuffer2) {
            while (n != -1) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append("''");
                n2 = n + 1;
                n = string.indexOf(39, n2);
            }
            stringBuffer.append(string.substring(n2, n));
            return stringBuffer.toString();
        }
    }

    public boolean hasNext(int n) {
        if (this.next == null) {
            this.checkNext(n, true);
        }
        return this.next != null;
    }

    private void checkNext(int n, boolean bl) {
        try {
            switch (n) {
                case 0: {
                    boolean bl2 = this.rs.next();
                    if (bl2) {
                        String string = this.rs.getString(1);
                        if (bl) {
                            this.next = string;
                            this.rs.previous();
                            break;
                        }
                        this.previous = this.current;
                        this.current = string;
                        this.next = null;
                        break;
                    }
                    if (bl) {
                        this.rs.previous();
                        break;
                    }
                    this.previous = this.current;
                    this.current = null;
                    this.next = null;
                    break;
                }
                case 1: {
                    boolean bl3 = this.rs.previous();
                    if (bl3) {
                        String string = this.rs.getString(1);
                        if (bl) {
                            this.previous = string;
                            this.rs.next();
                            break;
                        }
                        this.next = this.current;
                        this.current = string;
                        this.previous = null;
                        break;
                    }
                    if (bl) {
                        this.rs.next();
                        break;
                    }
                    this.next = this.current;
                    this.current = null;
                    this.previous = null;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public String getCurrentId() {
        return this.current;
    }

    public String getNextId(int n) {
        this.checkNext(n, false);
        return this.current;
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null && this.connectionPool != null) {
                this.connectionPool.releaseConnection(this.conn);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

