/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import com.deltax.util.TimeInterval;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sadun.util.OperationTimedoutException;
import org.sadun.util.TelnetInputStream;

public class TelnetInputStreamConsumer
extends FilterInputStream {
    private long consumptionOperationsTimeout;
    private PrintStream debugStream;
    public static final long BASIC_CRITERIA_CHECK_TIME = 100L;
    static /* synthetic */ Class class$org$sadun$util$TelnetInputStreamConsumer$CompositeCriterium;

    public TelnetInputStreamConsumer(TelnetInputStream telnetInputStream) {
        super(telnetInputStream);
        this.debugStream = telnetInputStream.getDebugStream();
    }

    public void registerTelnetCommandListener(TelnetInputStream.TelnetCommandListener telnetCommandListener) {
        ((TelnetInputStream)this.in).registerTelnetCommandListener(telnetCommandListener);
    }

    public void removeTelnetCommandListener(TelnetInputStream.TelnetCommandListener telnetCommandListener) {
        ((TelnetInputStream)this.in).removeTelnetCommandListener(telnetCommandListener);
    }

    public String consumeInput(long l) throws IOException {
        boolean bl = true;
        long l2 = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        while (bl) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return stringBuffer.toString();
            }
            int n = -1;
            while (this.in.available() > 0) {
                n = this.in.read();
                if (this.debugStream != null) {
                    this.debugStream.print((char)n);
                }
                stringBuffer.append((char)n);
            }
            long l3 = System.currentTimeMillis();
            if (l3 - l2 > l) {
                bl = false;
            }
            if (n == -1) continue;
            l2 = l3;
        }
        return stringBuffer.toString();
    }

    public String consumeInput(Pattern pattern, boolean bl) throws IOException, OperationTimedoutException {
        return this.consumeByCriteria(new PatternBasedCriterium(pattern, bl));
    }

    public String consumeInput(Pattern pattern) throws IOException, OperationTimedoutException {
        return this.consumeInput(pattern, true);
    }

    public String consumeInputUntilStringFoundAtEnd(String string) throws IOException, OperationTimedoutException {
        return this.consumeByCriteria(new StringEndBasedCriterium(string));
    }

    public String consumeInputUntilStringFoundAtEnd(String[] stringArray) throws IOException, OperationTimedoutException {
        Criterium[] criteriumArray = new Criterium[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            criteriumArray[i] = new StringEndBasedCriterium(stringArray[i]);
        }
        return this.consumeByCriteria(new OrCriterium(criteriumArray));
    }

    public String consumeInputUntilStringFound(String string) throws IOException, OperationTimedoutException {
        return this.consumeByCriteria(new ContainsStringCriterium(string));
    }

    public String consumeInputUntilStringFound(String[] stringArray) throws IOException, OperationTimedoutException {
        Criterium[] criteriumArray = new Criterium[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            criteriumArray[i] = new ContainsStringCriterium(stringArray[i]);
        }
        return this.consumeByCriteria(new OrCriterium(criteriumArray));
    }

    public String consumeByCriteria(Criterium criterium) throws IOException, OperationTimedoutException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        long l = System.currentTimeMillis();
        do {
            long l2;
            String string;
            boolean bl2 = bl = !criterium.holds(string = this.consumeInput(100L));
            if (string.length() > 0) {
                stringBuffer.append(string);
                l = System.currentTimeMillis();
                continue;
            }
            if (this.consumptionOperationsTimeout == 0L || (l2 = System.currentTimeMillis()) - l <= this.consumptionOperationsTimeout) continue;
            throw new OperationTimedoutException("Consumption operation timed out: no input from telnet host in " + TimeInterval.describe(this.consumptionOperationsTimeout) + ". Received input follows:" + System.getProperty("line.separator") + stringBuffer.toString());
        } while (bl);
        return stringBuffer.toString();
    }

    public boolean consumeUntilResultOrFailure(String string, String string2, String[] stringArray) throws IOException, OperationTimedoutException {
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("Invalid argument: the result array parameter is used to contain the string read from the telnet stream, so it must be of length 1. The passed array has length " + stringArray.length);
        }
        ContainsStringCriterium containsStringCriterium = new ContainsStringCriterium(string);
        ContainsStringCriterium containsStringCriterium2 = new ContainsStringCriterium(string2);
        OrCriterium orCriterium = new OrCriterium(containsStringCriterium, containsStringCriterium2);
        stringArray[0] = this.consumeByCriteria(orCriterium);
        if (orCriterium.isVerifiedAndHolds(containsStringCriterium)) {
            if (orCriterium.isVerifiedAndHolds(containsStringCriterium2)) {
                throw new RuntimeException("Internal error: both failure and success criteria hold - i.e. both strings are found in the telnet result. Please adjust the strings so that they indicates either success or failure");
            }
            return true;
        }
        if (orCriterium.isVerifiedAndHolds(containsStringCriterium2)) {
            return false;
        }
        throw new RuntimeException("Internal error: neither success nor failure criteria hold, but consumeByCriteria() has exited without an exception. This looks like a bug in consumeByCriteria()");
    }

    public long getConsumptionOperationsTimeout() {
        return this.consumptionOperationsTimeout;
    }

    public void setConsumptionOperationsTimeout(long l) {
        this.consumptionOperationsTimeout = l;
    }

    TelnetInputStream getTelnetInputStream() {
        return (TelnetInputStream)this.in;
    }

    public static class NoMoreInputAvailableCriterium
    implements Criterium {
        private long timeout;
        private long lastInvocationTime = -1L;
        private boolean cumulative;

        public NoMoreInputAvailableCriterium(boolean bl, long l) {
            this.timeout = l;
            this.cumulative = bl;
        }

        public NoMoreInputAvailableCriterium(boolean bl) {
            this(bl, 200L);
        }

        public boolean holds(String string) {
            if (this.lastInvocationTime == -1L) {
                this.lastInvocationTime = System.currentTimeMillis();
                return false;
            }
            if (string.length() > 0) {
                if (!this.cumulative) {
                    this.lastInvocationTime = System.currentTimeMillis();
                    return false;
                }
                long l = System.currentTimeMillis();
                return l - this.lastInvocationTime > this.timeout;
            }
            long l = System.currentTimeMillis();
            return l - this.lastInvocationTime > this.timeout;
        }

        public String toString() {
            return "no more input is available";
        }
    }

    public static class ContainsStringCriterium
    implements Criterium {
        private String s;

        public ContainsStringCriterium(String string) {
            this.s = string;
        }

        public boolean holds(String string) {
            return string.indexOf(this.s) != -1;
        }

        public String toString() {
            return "input contains " + this.s;
        }
    }

    public static class StringEndBasedCriterium
    implements Criterium {
        private String endString;

        public StringEndBasedCriterium(String string) {
            this.endString = string;
        }

        public boolean holds(String string) {
            return string.endsWith(this.endString);
        }

        public String toString() {
            return "input ends with " + this.endString;
        }
    }

    public static class PatternBasedCriterium
    implements Criterium {
        private Pattern toMatch;
        private boolean onlyAtEnd;

        PatternBasedCriterium(Pattern pattern, boolean bl) {
            this.toMatch = pattern;
            this.onlyAtEnd = bl;
        }

        public boolean holds(String string) {
            Matcher matcher = this.toMatch.matcher(string);
            if (matcher.lookingAt()) {
                if (this.onlyAtEnd) {
                    return matcher.end() == string.length();
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "input matches " + this.toMatch;
        }
    }

    public static class OrCriterium
    extends CompositeCriterium {
        public OrCriterium(Criterium criterium, Criterium criterium2) {
            this(new Criterium[]{criterium, criterium2});
        }

        public OrCriterium(Criterium[] criteriumArray) {
            super(criteriumArray);
        }

        public boolean holdsMultiple(String string) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (!this.operands[i].holds(string)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            for (int i = 0; i < this.operands.length; ++i) {
                printWriter.print(this.operands[i]);
                if (i >= this.operands.length - 1) continue;
                printWriter.print(" or ");
            }
            return stringWriter.toString();
        }
    }

    public static class AndCriterium
    extends CompositeCriterium {
        public AndCriterium(Criterium criterium, Criterium criterium2) {
            this(new Criterium[]{criterium, criterium2});
        }

        public AndCriterium(Criterium[] criteriumArray) {
            super(criteriumArray);
        }

        public boolean holdsMultiple(String string) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i].holds(string)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            for (int i = 0; i < this.operands.length; ++i) {
                printWriter.print(this.operands[i]);
                if (i >= this.operands.length - 1) continue;
                printWriter.print(" and ");
            }
            return stringWriter.toString();
        }
    }

    public static abstract class CompositeCriterium
    implements Criterium {
        private static final int NOT_VERIFIED = 0;
        private static final int HOLDS = 1;
        private static final int DOES_NOT_HOLD = 2;
        protected OperandWrapper[] operands;
        protected boolean verifyAllRequested;
        private int[] checkedState;

        protected CompositeCriterium(Criterium[] criteriumArray) {
            this(criteriumArray, false);
        }

        protected CompositeCriterium(Criterium[] criteriumArray, boolean bl) {
            this.verifyAllRequested = bl;
            this.operands = new OperandWrapper[criteriumArray.length];
            for (int i = 0; i < criteriumArray.length; ++i) {
                this.operands[i] = new OperandWrapper(criteriumArray[i], i);
            }
            this.checkedState = new int[criteriumArray.length];
            Arrays.fill(this.checkedState, 0);
        }

        public final boolean holds(String string) {
            if (this.verifyAllRequested) {
                for (int i = 0; i < this.operands.length; ++i) {
                    this.operands[i].holds(string);
                }
            }
            return this.holdsMultiple(string);
        }

        protected abstract boolean holdsMultiple(String var1);

        private Criterium[] getCriteriaByState(int n) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.checkedState.length; ++i) {
                if (this.checkedState[i] != n) continue;
                arrayList.add(new Integer(i));
            }
            Criterium[] criteriumArray = new Criterium[arrayList.size()];
            int n2 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                criteriumArray[n2++] = this.operands[n3].getWrappedCriterium();
            }
            return criteriumArray;
        }

        private Criterium getFirstCriteriaByState(int n) {
            Criterium[] criteriumArray = this.getCriteriaByState(n);
            if (criteriumArray.length == 0) {
                return null;
            }
            return criteriumArray[0];
        }

        public Criterium[] getHoldingCriteria() {
            return this.getCriteriaByState(1);
        }

        public Criterium getHoldingCriterium() {
            return this.getFirstCriteriaByState(1);
        }

        public Criterium[] getNotHoldingCriteria() {
            return this.getCriteriaByState(2);
        }

        private Criterium getNotHoldingCriterium() {
            return this.getFirstCriteriaByState(2);
        }

        public Criterium[] getUndefinedCriteria() {
            return this.getCriteriaByState(0);
        }

        private Criterium getUndefinedCriterium() {
            return this.getFirstCriteriaByState(0);
        }

        public boolean isVerifiedAndHolds(Criterium criterium) {
            return this.verifiedAndInAGivenState(criterium, 1);
        }

        public boolean isVerifiedAndDoesNotHold(Criterium criterium) {
            return this.verifiedAndInAGivenState(criterium, 2);
        }

        public boolean isVerified(Criterium criterium) {
            return !this.verifiedAndInAGivenState(criterium, 0);
        }

        private boolean verifiedAndInAGivenState(Criterium criterium, int n) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i].getWrappedCriterium() != criterium) continue;
                return this.checkedState[i] == n;
            }
            throw new IllegalArgumentException(criterium + " is not a criteria of this " + (class$org$sadun$util$TelnetInputStreamConsumer$CompositeCriterium == null ? (class$org$sadun$util$TelnetInputStreamConsumer$CompositeCriterium = TelnetInputStreamConsumer.class$("org.sadun.util.TelnetInputStreamConsumer$CompositeCriterium")) : class$org$sadun$util$TelnetInputStreamConsumer$CompositeCriterium).getName());
        }

        public boolean isVerifyAllRequested() {
            return this.verifyAllRequested;
        }

        public void setVerifyAllRequested(boolean bl) {
            this.verifyAllRequested = bl;
        }

        private class OperandWrapper
        implements Criterium {
            private Criterium c;
            private int position;

            OperandWrapper(Criterium criterium, int n) {
                this.c = criterium;
                this.position = n;
            }

            public boolean holds(String string) {
                boolean bl = this.c.holds(string);
                ((CompositeCriterium)CompositeCriterium.this).checkedState[this.position] = bl ? 1 : 2;
                return bl;
            }

            Criterium getWrappedCriterium() {
                return this.c;
            }

            public String toString() {
                return this.c.toString();
            }
        }
    }

    public static interface Criterium {
        public boolean holds(String var1);
    }
}

