/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.sadun.util.OperationTimedoutException;
import org.sadun.util.TelnetInputStream;
import org.sadun.util.TelnetInputStreamConsumer;
import org.sadun.util.TelnetNVTChannel;

public class UnixLoginHandler {
    private TelnetInputStreamConsumer is;
    private PrintStream os;
    private boolean sendInitialCRLF = false;
    private Socket socket;
    private long timeout = 0L;
    private String loginPromptSequence = "ogin:";
    private String loginIncorrectSequence = "ogin incorrect";
    private long loginIncorrectVerificationTime = 200L;
    private boolean checkForIncorrectLogin = true;

    public UnixLoginHandler(Socket socket) throws IOException {
        this(socket.getInputStream(), socket.getOutputStream(), true);
        this.socket = socket;
    }

    public UnixLoginHandler(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, true);
    }

    public UnixLoginHandler(Socket socket, boolean bl) throws IOException {
        this(socket.getInputStream(), socket.getOutputStream());
    }

    public UnixLoginHandler(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.is = new TelnetInputStreamConsumer(new TelnetNVTChannel(new BufferedInputStream(inputStream), outputStream));
        this.os = new PrintStream(outputStream, true);
        this.sendInitialCRLF = bl;
    }

    public UnixLoginHandler(String string, int n) throws UnknownHostException, IOException {
        this(new Socket(string, n));
    }

    public void registerTelnetCommandListener(TelnetInputStream.TelnetCommandListener telnetCommandListener) {
        this.is.registerTelnetCommandListener(telnetCommandListener);
    }

    public void removeTelnetCommandListener(TelnetInputStream.TelnetCommandListener telnetCommandListener) {
        this.is.removeTelnetCommandListener(telnetCommandListener);
    }

    public TelnetInputStreamConsumer doLogin(String string, String string2) throws IOException, OperationTimedoutException, LoginIncorrectException {
        if (this.sendInitialCRLF) {
            this.sendCRLF();
        }
        this.is.setConsumptionOperationsTimeout(this.timeout);
        this.is.consumeInputUntilStringFound(this.loginPromptSequence);
        this.os.print(string + "\r\n");
        this.os.flush();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Login sequence interrupted");
        }
        this.os.print(string2 + "\r\n");
        this.os.flush();
        if (this.checkForIncorrectLogin) {
            TelnetInputStreamConsumer.OrCriterium orCriterium = new TelnetInputStreamConsumer.OrCriterium(new TelnetInputStreamConsumer.ContainsStringCriterium(this.loginIncorrectSequence), new TelnetInputStreamConsumer.NoMoreInputAvailableCriterium(true, this.loginIncorrectVerificationTime));
            this.is.consumeByCriteria(orCriterium);
            if (orCriterium.getHoldingCriterium() instanceof TelnetInputStreamConsumer.ContainsStringCriterium) {
                throw new LoginIncorrectException();
            }
        }
        return this.is;
    }

    public void doLogout() {
        this.doLogout("\r\nexit", true);
    }

    public void doLogout(String string) {
        this.doLogout(string, false);
    }

    public void doLogout(String string, boolean bl) {
        if (this.os != null) {
            this.os.print(string);
            if (bl) {
                this.os.print("\r\n");
            }
            this.os.flush();
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                this.is = null;
            }
        }
        if (this.os != null) {
            this.os.close();
        }
        this.os = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public TelnetInputStreamConsumer getInputStream() {
        return this.is;
    }

    public PrintStream getOutputStream() {
        return this.os;
    }

    private void sendCRLF() throws IOException {
        this.os.write(13);
        this.os.write(10);
        this.os.flush();
    }

    public boolean isSendInitialCRLF() {
        return this.sendInitialCRLF;
    }

    public void setSendInitialCRLF(boolean bl) {
        this.sendInitialCRLF = bl;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public String getLoginIncorrectSequence() {
        return this.loginIncorrectSequence;
    }

    public void setLoginIncorrectSequence(String string) {
        this.loginIncorrectSequence = string;
    }

    public String getLoginPromptSequence() {
        return this.loginPromptSequence;
    }

    public void setLoginPromptSequence(String string) {
        this.loginPromptSequence = string;
    }

    public long getLoginIncorrectVerificationTime() {
        return this.loginIncorrectVerificationTime;
    }

    public void setLoginIncorrectVerificationTime(long l) {
        this.loginIncorrectVerificationTime = l;
    }

    public boolean isCheckForIncorrectLogin() {
        return this.checkForIncorrectLogin;
    }

    public void setCheckForIncorrectLogin(boolean bl) {
        this.checkForIncorrectLogin = bl;
    }

    public boolean areYouThere(long l) {
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream.flush();
            outputStream.write(255);
            outputStream.write(246);
            String string = this.is.consumeInput(l);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final class LoginIncorrectException
    extends Exception {
    }
}

