/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.sadun.util.Version;

public class VersionImpl
implements Version {
    protected int major;
    protected int minor;
    protected int micro;
    protected String quality;
    protected long buildNumber;
    protected long buildTimeStamp;

    public VersionImpl(int n, int n2, int n3, String string, long l, long l2) {
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.quality = string;
        this.buildNumber = l;
        this.buildTimeStamp = l2;
    }

    public VersionImpl(int n, int n2, int n3, long l, long l2) {
        this(n, n2, n3, null, l, l2);
    }

    public VersionImpl(int n, int n2, int n3, long l) {
        this(n, n2, n3, null, l, -1L);
    }

    public VersionImpl(int n, int n2, long l) {
        this(n, n2, -1, null, l);
    }

    public VersionImpl(int n, int n2, int n3, String string, long l) {
        this(n, n2, n3, string, l, -1L);
    }

    public VersionImpl(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, -1L);
    }

    public VersionImpl(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public VersionImpl(int n, int n2, int n3, String string, long l, String string2, Locale locale) throws ParseException {
        this(n, n2, n3, string, l, DateFormat.getDateTimeInstance(3, 3, locale).parse(string2).getTime());
    }

    public VersionImpl(int n, int n2, int n3, String string, long l, String string2) throws ParseException {
        this(n, n2, n3, string, l, string2, Locale.getDefault());
    }

    public int getMajorNumber() {
        return this.major;
    }

    public int getMinorNumber() {
        return this.minor;
    }

    public int getMicroNumber() {
        return this.micro;
    }

    public String getQualityState() {
        return this.quality;
    }

    public long getBuildNumber() {
        return this.buildNumber;
    }

    public long getBuildTimestamp() {
        return this.buildTimeStamp;
    }

    public String getShortDescription() {
        String string = this.getVersionNumber();
        if (string.length() == 0) {
            return this.getFullDescription();
        }
        return string;
    }

    private String getVersionNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.major != -1) {
            stringBuffer.append(this.major);
            if (this.minor != -1) {
                stringBuffer.append(".");
                stringBuffer.append(this.minor);
                if (this.micro != -1) {
                    stringBuffer.append(".");
                    stringBuffer.append(this.micro);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getFullDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getVersionNumber();
        stringBuffer.append(string);
        if (this.quality != null) {
            stringBuffer.append(this.quality);
        }
        if (this.buildNumber != -1L || this.buildTimeStamp != -1L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            if (this.buildNumber != -1L) {
                stringBuffer.append("build ");
                stringBuffer.append(this.buildNumber);
            }
            if (this.buildTimeStamp != -1L) {
                if (this.buildNumber != -1L) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(DateFormat.getDateTimeInstance(3, 3).format(new Date(this.buildTimeStamp)));
            }
        }
        return stringBuffer.toString();
    }

    public boolean hasInfoEnough() {
        if (this.major != -1) {
            return true;
        }
        if (this.quality != null) {
            return true;
        }
        if (this.buildNumber != -1L) {
            return true;
        }
        return this.buildTimeStamp != -1L;
    }

    public long getBuildTimeStamp() {
        return this.buildTimeStamp;
    }

    public void setBuildTimeStamp(long l) {
        this.buildTimeStamp = l;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public int getMicro() {
        return this.micro;
    }

    public void setMicro(int n) {
        this.micro = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String string) {
        this.quality = string;
    }

    public void setBuildNumber(long l) {
        this.buildNumber = l;
    }
}

