/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.pool2;

import java.io.File;
import org.sadun.util.pool2.ObjectPool;

public class Configuration {
    private File storageDirectory;
    private int poolSize;
    private ObjectPool.PassivationManagerFactory passivationManagerFactory;

    public Configuration(File file, int n, ObjectPool.PassivationManagerFactory passivationManagerFactory) {
        this.storageDirectory = file;
        this.poolSize = n;
        this.passivationManagerFactory = passivationManagerFactory;
    }

    public Configuration(File file, int n) {
        this(file, n, new ObjectPool.DefaultPassivationManagerFactory());
    }

    public Configuration(int n) {
        this(new File(System.getProperty("java.io.tmpdir")), n, new ObjectPool.DefaultPassivationManagerFactory());
    }

    public File getStorageDirectory() {
        return this.storageDirectory;
    }

    public void setStorageDirectory(File file) {
        this.storageDirectory = file;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int n) {
        this.poolSize = n;
    }

    public ObjectPool.PassivationManagerFactory getPassivationManagerFactory() {
        return this.passivationManagerFactory;
    }

    public void setPassivationManagerFactory(ObjectPool.PassivationManagerFactory passivationManagerFactory) {
        this.passivationManagerFactory = passivationManagerFactory;
    }
}

