/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.sis;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sadun.util.IndentedPrintWriter;
import org.sadun.util.ListMapIterator;
import org.sadun.util.sis.InfoEntry;

public class StateInfoSupport {
    private Map entries = new HashMap();
    private List keys = new ArrayList();
    private String lastKey;
    private int level;

    private synchronized void addEntry(String string, InfoEntry infoEntry) {
        ArrayList<InfoEntry> arrayList;
        if (!string.equals(this.lastKey)) {
            this.keys.add(string);
            this.lastKey = string;
        }
        if ((arrayList = (ArrayList<InfoEntry>)this.entries.get(string)) == null) {
            arrayList = new ArrayList<InfoEntry>();
            this.entries.put(string, arrayList);
        }
        arrayList.add(infoEntry);
    }

    public void addEntry(String string, String string2) {
        this.addEntry(string, new InfoEntry(string2, this.level));
    }

    public void addEntry(String string, String string2, Throwable throwable) {
        this.addEntry(string, new InfoEntry(string2, this.level, throwable));
    }

    public void addEntry(String string) {
        this.checkLastKey();
        this.addEntry(this.lastKey, new InfoEntry(string, this.level));
    }

    public void addEntry(String string, Throwable throwable) {
        this.checkLastKey();
        this.addEntry(this.lastKey, new InfoEntry(string, this.level, throwable));
    }

    private void checkLastKey() {
        if (this.lastKey == null) {
            IllegalStateException illegalStateException = new IllegalStateException("StateInfoSupport: no last key set. Please use the addEntry(String key, ...) overload on the first entry.");
            throw illegalStateException;
        }
    }

    public synchronized String getStateDescription(String string) {
        Object object;
        Iterator iterator;
        StringWriter stringWriter = new StringWriter();
        IndentedPrintWriter indentedPrintWriter = new IndentedPrintWriter(stringWriter);
        if (string == null || "".equals(string)) {
            iterator = new ListMapIterator(this.entries, this.keys);
        } else {
            object = (List)this.entries.get(string);
            if (object == null) {
                return null;
            }
            iterator = object.iterator();
        }
        object = null;
        while (iterator.hasNext()) {
            List list;
            object = iterator instanceof ListMapIterator ? (String)((ListMapIterator)iterator).getCurrentKey() : string;
            if (!((String)object).equals(list = object)) {
                indentedPrintWriter.println();
                indentedPrintWriter.println("{" + (String)object + "} ");
                indentedPrintWriter.println();
            }
            InfoEntry infoEntry = (InfoEntry)iterator.next();
            indentedPrintWriter.incIndentation(5 + infoEntry.getLevel());
            indentedPrintWriter.println(infoEntry);
            indentedPrintWriter.decIndentation(5);
        }
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        StateInfoSupport stateInfoSupport = new StateInfoSupport();
        stateInfoSupport.addEntry("intialization", "all is right");
        stateInfoSupport.addEntry("something going wrong", new IllegalStateException("illegal state"));
        stateInfoSupport.addEntry("doing something", "all ok");
        stateInfoSupport.addEntry("ops!", new RuntimeException("something didnt work"));
        System.out.println(stateInfoSupport.getStateDescription("intialization"));
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }
}

