/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.sql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.sadun.util.DynamicClassLoader;
import org.sadun.util.ObjectLister;

public class DynamicConnectionFactory {
    private Class cls;
    private Object factoryInternal;
    private DynamicClassLoader loader;

    public DynamicConnectionFactory() {
        this(new DynamicClassLoader());
    }

    private DynamicConnectionFactory(DynamicClassLoader dynamicClassLoader) {
        this.loader = dynamicClassLoader;
        dynamicClassLoader.setForceDynamicLoading(true);
        try {
            this.cls = dynamicClassLoader.loadClass("org.sadun.util.sql.ConnectionFactoryInternal");
            try {
                Constructor constructor = this.cls.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.factoryInternal = constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Unexpectedly can't find the default constructor in the utility class org.sadun.util.sql.ConnectionFactoryInternal", noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Unexpectedly can't invoke the default constructor in the utility class org.sadun.util.sql.ConnectionFactoryInternal", invocationTargetException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpectedly can't find the utility class org.sadun.util.sql.ConnectionFactoryInternal", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Unexpectedly can't instantiate the utility class org.sadun.util.sql.ConnectionFactoryInternal", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Unexpectedly can't access the utility class org.sadun.util.sql.ConnectionFactoryInternal", illegalAccessException);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    public void addClassPathEntry(String string) {
        this.loader.addClassPathEntry(string);
    }

    public void setClassPath(String string) {
        this.loader.setClassPath(string);
    }

    public Class loadDriver(String string) throws ClassNotFoundException {
        return Class.forName(string, true, this.loader);
    }

    private Connection invoke(Class[] classArray, Object[] objectArray) throws SQLException {
        try {
            Method method = this.cls.getMethod("getConnection", classArray);
            method.setAccessible(true);
            try {
                return (Connection)method.invoke(this.factoryInternal, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof SQLException) {
                    throw (SQLException)invocationTargetException.getCause();
                }
                throw new RuntimeException(invocationTargetException);
            }
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            new ObjectLister("\r\n").println(this.cls.getMethods());
            throw new RuntimeException("Could not find method getConnection() with args (" + new ObjectLister('\u0000').list(classArray) + ")", noSuchMethodException);
        }
    }

    public Connection getConnection(String string, Properties properties) throws SQLException {
        return this.invoke(new Class[]{String.class, Properties.class}, new Object[]{string, properties});
    }

    public Connection getConnection(String string) throws SQLException {
        return this.invoke(new Class[]{String.class}, new Object[]{string});
    }

    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        return this.invoke(new Class[]{String.class, String.class, String.class}, new Object[]{string, string2, string3});
    }
}

