/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.test;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.swingui.TestRunner;
import org.sadun.util.PushbackReader;

public class PushbackReaderTest
extends TestCase {
    private Reader reader;
    private PushbackReader pr;

    public static void main(String[] stringArray) {
        TestRunner.run((Class)PushbackReaderTest.class);
    }

    protected void setUp() throws Exception {
        this.reader = new StringReader("Hello\r\nworld");
        this.pr = new PushbackReader(this.reader);
    }

    public void testUnread() throws IOException {
        int n = this.pr.read();
        this.pr.unread(n);
        int n2 = this.pr.read();
        PushbackReaderTest.assertEquals((int)n, (int)n2);
    }

    public void testReadNext() throws IOException {
        String string = this.pr.readNext(5);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 5; ++i) {
            stringBuffer.append((char)this.pr.read());
        }
        PushbackReaderTest.assertEquals((String)string, (String)stringBuffer.toString());
    }

    public void testNextEquals() throws IOException {
        boolean bl = this.pr.nextEquals("Hello");
        PushbackReaderTest.assertTrue((boolean)bl);
        boolean bl2 = this.pr.nextEquals("World");
        PushbackReaderTest.assertFalse((boolean)bl2);
        bl = this.pr.nextEquals("Hello", false);
        PushbackReaderTest.assertTrue((boolean)bl);
        bl2 = this.pr.nextEquals("\r\nworld");
        PushbackReaderTest.assertTrue((boolean)bl2);
    }
}

