/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.tp;

import org.sadun.util.tp.FIFOQueue;
import org.sadun.util.tp.Queue;

public class ThreadPool {
    private boolean shutdown = false;
    private int size;
    private Queue queue;
    private PooledThread[] pool;
    public boolean verbose;

    private Runnable getNextThread() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.get();
    }

    public ThreadPool(int n, boolean bl, Queue queue) {
        boolean bl2 = this.verbose = System.getProperty("org.sadun.verbose") != null;
        if (this.verbose) {
            System.out.println("Creating thread pool of size " + n);
        }
        this.queue = queue;
        this.pool = new PooledThread[n];
        ThreadGroup threadGroup = new ThreadGroup("thread-pool");
        for (int i = 0; i < n; ++i) {
            this.pool[i] = new PooledThread(threadGroup, i, bl);
            this.pool[i].start();
        }
    }

    public ThreadPool(int n, boolean bl) {
        this(n, bl, new FIFOQueue());
    }

    public ThreadPool(int n) {
        this(n, true);
    }

    public int size() {
        return this.pool.length;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public boolean start(Runnable runnable) {
        return this.start(runnable, false);
    }

    public boolean start(Runnable runnable, boolean bl) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.pool[i].isFree()) continue;
            this.pool[i].setRunnable(runnable);
            return true;
        }
        if (!bl) {
            if (this.verbose) {
                System.out.println("{" + Thread.currentThread() + "} " + "Queueing " + runnable);
            }
            this.queue.put(runnable);
        }
        return false;
    }

    public synchronized boolean isAlive(Runnable runnable) {
        for (int i = 0; i < this.pool.length; ++i) {
            if (runnable != this.pool[i].getRunnable()) continue;
            return true;
        }
        return false;
    }

    public synchronized int getBusyCount() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.pool[i].isFree()) continue;
            ++n;
        }
        return n;
    }

    public void terminate() {
        this.shutdown = true;
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.verbose) {
                System.out.println("{" + Thread.currentThread() + "} " + "Interrupting " + this.pool[i].getName());
            }
            this.pool[i].interrupt();
        }
    }

    public class PooledThread
    extends Thread {
        private Runnable runnable;
        private boolean waiting;
        int i;

        PooledThread(ThreadGroup threadGroup, int n, boolean bl) {
            super(threadGroup, "pooled-thread-" + n);
            this.waiting = true;
            this.i = n;
            this.setDaemon(bl);
        }

        private synchronized void setRunnable(Runnable runnable) {
            if (!this.isFree()) {
                throw new IllegalStateException("Thread " + this.getName() + " in the pool is not free");
            }
            if (ThreadPool.this.verbose) {
                System.out.println("{" + Thread.currentThread() + "} " + "Thread " + this + " is free, associating " + runnable);
            }
            this.runnable = runnable;
            this.waiting = false;
            this.notify();
        }

        public final synchronized void run() {
            do {
                block9: {
                    if (this.runnable != null) {
                        this.waiting = false;
                        try {
                            this.runnable.run();
                        }
                        catch (Exception exception) {
                            this.runnable = null;
                            exception.printStackTrace();
                        }
                    }
                    this.runnable = ThreadPool.this.getNextThread();
                    if (this.runnable != null) {
                        if (!ThreadPool.this.verbose) continue;
                        System.out.println("{" + Thread.currentThread() + "} " + "Dequeueed " + this.runnable + " (" + ThreadPool.this.queue.size() + " in queue)");
                        continue;
                    }
                    this.waiting = true;
                    try {
                        if (ThreadPool.this.verbose) {
                            System.out.println("{" + Thread.currentThread() + "} " + this + " going to wait.");
                        }
                        this.wait(0L);
                        if (ThreadPool.this.verbose) {
                            System.out.println("{" + Thread.currentThread() + "} " + this + " notified.");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!ThreadPool.this.verbose) break block9;
                        System.out.println("{" + Thread.currentThread() + "} " + this + " INTERRUPTED!");
                    }
                }
                this.waiting = false;
            } while (!ThreadPool.this.shutdown);
        }

        protected boolean isFree() {
            return this.waiting;
        }

        protected Runnable getRunnable() {
            return this.runnable;
        }

        public String toString() {
            return this.getName();
        }

        public void finalize() {
            ThreadPool.this.terminate();
        }
    }
}

