/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.ObjectGraphHandler;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.collection.CollectionInterceptorUtil;
import org.jboss.cache.aop.util.AopUtil;

public class CollectionClassHandler {
    protected TreeCacheAop cache_;
    protected InternalDelegate internal_;
    protected ObjectGraphHandler graphHandler_;
    protected static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$aop$ObjectGraphHandler == null ? (class$org$jboss$cache$aop$ObjectGraphHandler = CollectionClassHandler.class$("org.jboss.cache.aop.ObjectGraphHandler")) : class$org$jboss$cache$aop$ObjectGraphHandler));
    static /* synthetic */ Class class$org$jboss$cache$aop$ObjectGraphHandler;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;

    public CollectionClassHandler(TreeCacheAop cache, InternalDelegate internal, ObjectGraphHandler graphHandler) {
        this.cache_ = cache;
        this.internal_ = internal;
        this.graphHandler_ = graphHandler;
    }

    Object collectionObjectGet(Fqn fqn, Class clazz) throws CacheException {
        ClassProxy obj = null;
        try {
            if ((class$java$util$Map == null ? (class$java$util$Map = CollectionClassHandler.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
                obj = CollectionInterceptorUtil.createMapProxy(this.cache_, fqn, clazz);
            } else if ((class$java$util$List == null ? (class$java$util$List = CollectionClassHandler.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
                obj = CollectionInterceptorUtil.createListProxy(this.cache_, fqn, clazz);
            } else if ((class$java$util$Set == null ? (class$java$util$Set = CollectionClassHandler.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(clazz)) {
                obj = CollectionInterceptorUtil.createSetProxy(this.cache_, fqn, clazz);
            }
        }
        catch (Exception e) {
            throw new CacheException("failure creating proxy", e);
        }
        return obj;
    }

    boolean collectionObjectPut(Fqn fqn, Object obj) throws CacheException {
        boolean isCollection = false;
        CachedType type = this.cache_.getCachedType(obj.getClass());
        this.internal_.resetRefCount(fqn);
        if (obj instanceof ClassProxy) {
            Interceptor interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
            if (((AbstractCollectionInterceptor)interceptor).isAttached()) {
                if (this.graphHandler_.objectGraphPut(fqn, interceptor, type, obj)) {
                    return true;
                }
            } else {
                ((AbstractCollectionInterceptor)interceptor).attach(fqn);
                this.internal_.putAopClazz(fqn, type.getType());
                this.internal_.setPojo(fqn, obj);
                return true;
            }
        }
        if (obj instanceof Map) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("collectionPutObject(): aspectized obj is a Map type of size: " + ((Map)obj).size()));
            }
            this.cache_.removeObject(fqn);
            this.internal_.putAopClazz(fqn, type.getType());
            Map map = (Map)obj;
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createMapProxy(this.cache_, fqn, clazz);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.cache_._putObject(new Fqn(fqn, entry.getKey()), entry.getValue());
            }
            this.internal_.setPojo(fqn, obj);
            isCollection = true;
        } else if (obj instanceof List) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("collectionPutObject(): aspectized obj is a List type of size: " + ((List)obj).size()));
            }
            List list = (List)obj;
            this.cache_.removeObject(fqn);
            this.internal_.putAopClazz(fqn, type.getType());
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createListProxy(this.cache_, fqn, clazz);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            int idx = 0;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.cache_._putObject(AopUtil.constructFqn(fqn, Integer.toString(idx++)), i.next());
            }
            this.internal_.setPojo(fqn, obj);
            isCollection = true;
        } else if (obj instanceof Set) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("collectionPutObject(): aspectized obj is a Set type of size: " + ((Set)obj).size()));
            }
            Set set = (Set)obj;
            this.cache_.removeObject(fqn);
            this.internal_.putAopClazz(fqn, type.getType());
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createSetProxy(this.cache_, fqn, clazz);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", e);
                }
            }
            int idx = 0;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                this.cache_._putObject(AopUtil.constructFqn(fqn, Integer.toString(idx++)), i.next());
            }
            this.internal_.setPojo(fqn, obj);
            isCollection = true;
        }
        return isCollection;
    }

    boolean collectionObjectRemove(Fqn fqn, boolean removeCacheInterceptor, boolean evict) throws CacheException {
        Class clazz;
        if (!(class$java$util$Map == null ? (class$java$util$Map = CollectionClassHandler.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz = this.internal_.peekAopClazz(fqn)) && !(class$java$util$Collection == null ? (class$java$util$Collection = CollectionClassHandler.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            return false;
        }
        Object obj = this.cache_.getObject(fqn);
        if (!(obj instanceof ClassProxy)) {
            throw new RuntimeException("CollectionClassHandler.collectionRemoveObject(): object is not a proxy :" + obj);
        }
        Interceptor interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
        ((AbstractCollectionInterceptor)interceptor).detach();
        return true;
    }

    void collectionReplaceWithProxy(Object obj, Object value, Field field, Fqn tmpFqn) throws CacheException {
        if (value instanceof Map || value instanceof List || value instanceof Set) {
            Object newValue = this.cache_.getObject(tmpFqn);
            try {
                field.set(obj, newValue);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("collectionReplaceWithProxy(): Can't swap out the Collection class of field " + field.getName() + "Exception " + e));
                throw new CacheException("CollectionClassHandler.collectionReplaceWithProxy(): Can't swap out the Collection class of field \" +field.getName()," + e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

