/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockejb.MethodNotImplementedException;
import org.mockejb.jndi.MockContextNameParser;

public class MockContext
implements Context {
    private static final String ROOT_CONTEXT_NAME = "ROOT";
    private static final NameParser nameParser = new MockContextNameParser();
    private static Log logger = LogFactory.getLog((String)(class$org$mockejb$jndi$MockContext == null ? (class$org$mockejb$jndi$MockContext = MockContext.class$("org.mockejb.jndi.MockContext")) : class$org$mockejb$jndi$MockContext).getName());
    private final Map objects = Collections.synchronizedMap(new HashMap());
    private MockContext parent;
    private String contextName;
    private Context remoteContext;
    private boolean isDestroyed;
    static /* synthetic */ Class class$org$mockejb$jndi$MockContext;

    protected MockContext(Context remoteContext) {
        this(remoteContext, null, ROOT_CONTEXT_NAME);
    }

    private MockContext(Context remoteContext, MockContext parent, String name) {
        this.remoteContext = remoteContext;
        this.parent = parent;
        this.contextName = name;
        this.isDestroyed = false;
    }

    public Object addToEnvironment(String arg0, Object arg1) throws NamingException {
        this.throwMethodNotImplemented("addToEnvironment( String, Object)");
        return null;
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.checkIsDestroyed();
        this.rebind(name, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(nameParser.parse(name), obj);
    }

    public void close() throws NamingException {
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        this.checkIsDestroyed();
        Name parsedPrefix = this.getParsedName((Name)prefix.clone());
        Name parsedName = this.getParsedName(name);
        return parsedPrefix.addAll(parsedName);
    }

    public String composeName(String name, String prefix) throws NamingException {
        this.checkIsDestroyed();
        return this.composeName(nameParser.parse(name), nameParser.parse(prefix)).toString();
    }

    public Context createSubcontext(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String subContextName = parsedName.get(0);
        Object boundObject = this.objects.get(parsedName.get(0));
        if (parsedName.size() == 1) {
            if (boundObject == null) {
                MockContext subContext = new MockContext(this.remoteContext, this, subContextName);
                this.objects.put(subContextName, subContext);
                return subContext;
            }
            throw new NameAlreadyBoundException("Name " + subContextName + " is already bound!");
        }
        if (boundObject instanceof Context) {
            return ((Context)boundObject).createSubcontext(parsedName.getSuffix(1));
        }
        throw new NotContextException("Expected Context but found " + boundObject);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(nameParser.parse(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroySubcontext(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String subContextName = parsedName.get(0);
        Object boundObject = this.objects.get(subContextName);
        if (boundObject == null) {
            throw new NameNotFoundException("Name " + subContextName + "not found in the context!");
        }
        if (!(boundObject instanceof MockContext)) {
            throw new NotContextException();
        }
        MockContext contextToDestroy = (MockContext)boundObject;
        if (parsedName.size() == 1) {
            if (contextToDestroy.objects.size() != 0) throw new ContextNotEmptyException("Can not destroy non-empty Context!");
            this.objects.remove(subContextName);
            contextToDestroy.destroyInternal();
            return;
        } else {
            ((MockContext)boundObject).destroySubcontext(parsedName.getSuffix(1));
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(nameParser.parse(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        this.throwMethodNotImplemented("getEnvironment()");
        return null;
    }

    public String getNameInNamespace() throws NamingException {
        this.throwMethodNotImplemented("getNameInNamespace()");
        return null;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        this.checkIsDestroyed();
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        this.checkIsDestroyed();
        return nameParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(nameParser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0) {
            Vector<Binding> bindings = new Vector<Binding>();
            Iterator iterat = this.objects.keySet().iterator();
            while (iterat.hasNext()) {
                String bindingName = (String)iterat.next();
                bindings.addElement(new Binding(bindingName, this.objects.get(bindingName)));
            }
            return new NamingEnumerationImpl(bindings);
        }
        Object subContext = this.objects.get(parsedName.get(0));
        if (subContext instanceof Context) {
            return ((Context)subContext).list(parsedName.getSuffix(1));
        }
        if (subContext == null && !this.objects.containsKey(parsedName.get(0))) {
            throw new NameNotFoundException("Name " + name + " not found");
        }
        throw new NotContextException("Expected Context but found " + subContext);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(nameParser.parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        this.checkIsDestroyed();
        try {
            return this.lookupInternal(name);
        }
        catch (NameNotFoundException ex) {
            if (this.remoteContext != null) {
                logger.debug((Object)("Was not able to find name " + name + " in the local context. Will try remote context."));
                return this.remoteContext.lookup(name);
            }
            throw new NameNotFoundException("Name " + name + " not found. ");
        }
    }

    private Object lookupInternal(Name name) throws NamingException {
        Name parsedName = this.getParsedName(name);
        String nameComponent = parsedName.get(0);
        Object res = this.objects.get(nameComponent);
        if (!this.objects.containsKey(nameComponent)) {
            throw new NameNotFoundException("Name " + name + " not found.");
        }
        if (parsedName.size() > 1) {
            if (res instanceof MockContext) {
                res = ((MockContext)res).lookupInternal(parsedName.getSuffix(1));
            } else {
                throw new NotContextException("Expected MockContext but found " + res);
            }
        }
        return res;
    }

    public Object lookup(String name) throws NamingException {
        this.checkIsDestroyed();
        try {
            return this.lookupInternal(name);
        }
        catch (NameNotFoundException ex) {
            if (this.remoteContext != null) {
                logger.debug((Object)("Was not able to find name " + name + " in the local context. Will try remote context."));
                return this.remoteContext.lookup(name);
            }
            throw new NameNotFoundException("Name " + name + " not found. ");
        }
    }

    private Object lookupInternal(String name) throws NamingException {
        return this.lookupInternal(nameParser.parse(name));
    }

    public Object lookupLink(Name arg0) throws NamingException {
        this.throwMethodNotImplemented("lookupLink(Name)");
        return null;
    }

    public Object lookupLink(String arg0) throws NamingException {
        this.throwMethodNotImplemented("lookupLink(String)");
        return null;
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String nameToBind = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.objects.put(nameToBind, obj);
            logger.debug((Object)("Bound object " + obj + " to the name " + nameToBind));
        } else {
            Object boundObject = this.objects.get(nameToBind);
            if (boundObject instanceof Context) {
                ((Context)boundObject).bind(parsedName.getSuffix(1), obj);
            } else if (boundObject == null) {
                Context sub = this.createSubcontext(nameToBind);
                sub.bind(parsedName.getSuffix(1), obj);
            } else {
                throw new NotContextException("Expected Context but found " + boundObject);
            }
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(nameParser.parse(name), obj);
    }

    public Object removeFromEnvironment(String arg0) throws NamingException {
        this.throwMethodNotImplemented("removeFromEnvironment(String)");
        return null;
    }

    public void rename(Name arg0, Name arg1) throws NamingException {
        this.throwMethodNotImplemented("rename(Name arg0, Name arg1)");
    }

    public void rename(String arg0, String arg1) throws NamingException {
        this.throwMethodNotImplemented("rename(String arg0, String arg1)");
    }

    public void unbind(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String nameToRemove = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.objects.remove(nameToRemove);
            logger.debug((Object)("Unbound name " + name));
        } else {
            Object boundObject = this.objects.get(nameToRemove);
            if (boundObject instanceof Context) {
                ((Context)boundObject).unbind(parsedName.getSuffix(1));
            } else {
                if (!this.objects.containsKey(nameToRemove)) {
                    throw new NameNotFoundException("Can not find " + name);
                }
                throw new NotContextException("Expected Context but found " + boundObject);
            }
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(nameParser.parse(name));
    }

    private void checkIsDestroyed() throws NamingException {
        if (this.isDestroyed) {
            throw new NoPermissionException("Can not invoke operations on destroyed context!");
        }
    }

    private void destroyInternal() {
        this.isDestroyed = true;
    }

    private Name getParsedName(Name name) throws NamingException {
        Name result = null;
        if (name instanceof CompositeName) {
            if (name.size() == 0) {
                result = nameParser.parse("");
            } else if (name.size() > 1) {
                throw new InvalidNameException("Multiple name systems are not supported!");
            }
            result = nameParser.parse(name.get(0));
        } else {
            result = (Name)name.clone();
        }
        while (!result.isEmpty()) {
            if (result.get(0).length() == 0) {
                result.remove(0);
                continue;
            }
            if (result.get(result.size() - 1).length() != 0) break;
            result.remove(result.size() - 1);
        }
        for (int i = 1; i < result.size() - 1; ++i) {
            if (result.get(i).length() != 0) continue;
            throw new InvalidNameException("Empty intermediate components are not supported!");
        }
        return result;
    }

    String getCompoundStringName() throws NamingException {
        String compositeName = "";
        MockContext curCtx = this;
        while (!curCtx.isRootContext()) {
            compositeName = this.composeName(compositeName, curCtx.getAtomicName());
            curCtx = curCtx.getParentContext();
        }
        return compositeName;
    }

    MockContext getParentContext() {
        return this.parent;
    }

    String getAtomicName() {
        return this.contextName;
    }

    boolean isRootContext() {
        return this.getParentContext() == null;
    }

    private void throwMethodNotImplemented(String methodName) {
        throw new MethodNotImplementedException(methodName, this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NamingEnumerationImpl
    implements NamingEnumeration {
        private Vector elements;
        private int currentElement;

        NamingEnumerationImpl(Vector elements) {
            this.elements = elements;
            this.currentElement = 0;
        }

        public void close() {
            this.currentElement = 0;
            this.elements.clear();
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            if (this.currentElement < this.elements.size()) {
                return true;
            }
            this.close();
            return false;
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this.elements.get(this.currentElement++);
            }
            throw new NoSuchElementException();
        }
    }
}

