/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class KnownHosts
implements HostKeyRepository {
    private static final String _known_hosts = "known_hosts";
    private JSch jsch = null;
    private String known_hosts = null;
    private Vector pool = null;
    private static final byte[] space = new byte[]{32};
    private static final byte[] cr = "\n".getBytes();

    KnownHosts(JSch jSch) {
        this.jsch = jSch;
        this.pool = new Vector();
    }

    void setKnownHosts(String string) throws JSchException {
        try {
            this.known_hosts = string;
            FileInputStream fileInputStream = new FileInputStream(string);
            this.setKnownHosts(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    void setKnownHosts(InputStream inputStream) throws JSchException {
        this.pool.removeAllElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            InputStream inputStream2 = inputStream;
            String string = null;
            byte[] byArray = new byte[1024];
            int n = 0;
            block2: while (true) {
                int n2;
                n = 0;
                while ((n2 = inputStream2.read()) != -1) {
                    byte by;
                    if (n2 == 13) continue;
                    if (n2 != 10) {
                        byArray[n++] = (byte)n2;
                        continue;
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        by = byArray[n2];
                        if (by == 32 || by == 9) {
                            continue;
                        }
                        if (by != 35) break;
                        this.addInvalidLine(new String(byArray, 0, n));
                        continue block2;
                    }
                    if (n2 >= n) {
                        this.addInvalidLine(new String(byArray, 0, n));
                        continue block2;
                    }
                    stringBuffer.setLength(0);
                    while (n2 < n && (by = byArray[n2++]) != 32 && by != 9) {
                        stringBuffer.append((char)by);
                    }
                    String string2 = stringBuffer.toString();
                    if (n2 >= n || string2.length() == 0) {
                        this.addInvalidLine(new String(byArray, 0, n));
                        continue block2;
                    }
                    stringBuffer.setLength(0);
                    int n3 = -1;
                    while (n2 < n && (by = byArray[n2++]) != 32 && by != 9) {
                        stringBuffer.append((char)by);
                    }
                    if (stringBuffer.toString().equals("ssh-dss")) {
                        n3 = 0;
                    } else if (stringBuffer.toString().equals("ssh-rsa")) {
                        n3 = 1;
                    } else {
                        n2 = n;
                    }
                    if (n2 >= n) {
                        this.addInvalidLine(new String(byArray, 0, n));
                        continue block2;
                    }
                    stringBuffer.setLength(0);
                    while (n2 < n) {
                        if ((by = byArray[n2++]) == 13) continue;
                        if (by == 10) break;
                        stringBuffer.append((char)by);
                    }
                    if ((string = stringBuffer.toString()).length() == 0) {
                        this.addInvalidLine(new String(byArray, 0, n));
                        continue block2;
                    }
                    HostKey hostKey = new HostKey(string2, n3, Util.fromBase64(string.getBytes(), 0, string.length()));
                    this.pool.addElement(hostKey);
                    continue block2;
                }
                break;
            }
            inputStream2.close();
            if (bl) {
                throw new JSchException("KnownHosts: invalid format");
            }
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            throw new JSchException(exception.toString());
        }
    }

    private void addInvalidLine(String string) {
        HostKey hostKey = new HostKey(string, 2, null);
        this.pool.addElement(hostKey);
    }

    String getKnownHostsFile() {
        return this.known_hosts;
    }

    public String getKnownHostsRepositoryID() {
        return this.known_hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int check(String string, byte[] byArray) {
        int n = 1;
        int n2 = this.getType(byArray);
        Vector vector = this.pool;
        synchronized (vector) {
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hostKey = (HostKey)this.pool.elementAt(i);
                if (!this.isIncluded(hostKey.host, string) || hostKey.type != n2) continue;
                if (Util.array_equals(hostKey.key, byArray)) {
                    return 0;
                }
                n = 2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string, byte[] byArray, UserInfo userInfo) {
        HostKey hostKey;
        int n;
        int n2 = this.getType(byArray);
        Object object = this.pool;
        synchronized (object) {
            for (n = 0; n < this.pool.size(); ++n) {
                hostKey = (HostKey)this.pool.elementAt(n);
                if (this.isIncluded(hostKey.host, string) && hostKey.type != n2) continue;
            }
        }
        hostKey = new HostKey(string, n2, byArray);
        this.pool.addElement(hostKey);
        object = this.getKnownHostsRepositoryID();
        if (object != null) {
            n = 1;
            File file = new File((String)object);
            if (!file.exists()) {
                n = 0;
                if (userInfo != null) {
                    n = userInfo.promptYesNo((String)object + " does not exist.\n" + "Are you sure you want to create it?") ? 1 : 0;
                    file = file.getParentFile();
                    if (n != 0 && file != null && !file.exists() && (n = (int)(userInfo.promptYesNo("The parent directory " + file + " does not exist.\n" + "Are you sure you want to create it?") ? 1 : 0)) != 0) {
                        if (!file.mkdirs()) {
                            userInfo.showMessage(file + " has not been created.");
                            n = 0;
                        } else {
                            userInfo.showMessage(file + " has been succesfully created.\nPlease check its access permission.");
                        }
                    }
                    if (file == null) {
                        n = 0;
                    }
                }
            }
            if (n != 0) {
                try {
                    this.sync((String)object);
                }
                catch (Exception exception) {
                    System.out.println("sync known_hosts: " + exception);
                }
            }
        }
    }

    public HostKey[] getHostKey() {
        return this.getHostKey(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostKey[] getHostKey(String string, String string2) {
        Vector vector = this.pool;
        synchronized (vector) {
            int n = 0;
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hostKey = (HostKey)this.pool.elementAt(i);
                if (hostKey.type == 2 || string != null && (!this.isIncluded(hostKey.host, string) || string2 != null && !hostKey.getType().equals(string2))) continue;
                ++n;
            }
            if (n == 0) {
                return null;
            }
            HostKey[] hostKeyArray = new HostKey[n];
            int n2 = 0;
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hostKey = (HostKey)this.pool.elementAt(i);
                if (hostKey.type == 2 || string != null && (!this.isIncluded(hostKey.host, string) || string2 != null && !hostKey.getType().equals(string2))) continue;
                hostKeyArray[n2++] = hostKey;
            }
            return hostKeyArray;
        }
    }

    public void remove(String string, String string2) {
        this.remove(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string, String string2, byte[] byArray) {
        boolean bl = false;
        Vector vector = this.pool;
        synchronized (vector) {
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hostKey = (HostKey)this.pool.elementAt(i);
                if (string != null && (!hostKey.getHost().equals(string) || string2 != null && (!hostKey.getType().equals(string2) || byArray != null && !Util.array_equals(byArray, hostKey.key)))) continue;
                this.pool.removeElement(hostKey);
                bl = true;
            }
        }
        if (bl) {
            try {
                this.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sync() throws IOException {
        if (this.known_hosts != null) {
            this.sync(this.known_hosts);
        }
    }

    private void sync(String string) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.dump(fileOutputStream);
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(OutputStream outputStream) throws IOException {
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                for (int i = 0; i < this.pool.size(); ++i) {
                    HostKey hostKey = (HostKey)this.pool.elementAt(i);
                    String string = hostKey.getHost();
                    String string2 = hostKey.getType();
                    if (string2.equals("UNKNOWN")) {
                        outputStream.write(string.getBytes());
                        outputStream.write(cr);
                        continue;
                    }
                    outputStream.write(string.getBytes());
                    outputStream.write(space);
                    outputStream.write(string2.getBytes());
                    outputStream.write(space);
                    outputStream.write(hostKey.getKey().getBytes());
                    outputStream.write(cr);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private int getType(byte[] byArray) {
        if (byArray[8] == 100) {
            return 0;
        }
        if (byArray[8] == 114) {
            return 1;
        }
        return 2;
    }

    private String deleteSubString(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = string.length();
        while (n2 < n4 && (n = string.indexOf(44, n2)) != -1) {
            if (!string2.equals(string.substring(n2, n))) {
                n2 = n + 1;
                continue;
            }
            return string.substring(0, n2) + string.substring(n + 1);
        }
        if (string.endsWith(string2) && n4 - n2 == n3) {
            return string.substring(0, n3 == n4 ? 0 : n4 - n3 - 1);
        }
        return string;
    }

    private boolean isIncluded(String string, String string2) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string.length();
        while (n < n3) {
            int n4 = string.indexOf(44, n);
            if (n4 == -1) {
                if (n2 != n3 - n) {
                    return false;
                }
                return string.regionMatches(true, n, string2, 0, n2);
            }
            if (n2 == n4 - n && string.regionMatches(true, n, string2, 0, n2)) {
                return true;
            }
            n = n4 + 1;
        }
        return false;
    }
}

