/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.cluster.FileRecord;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefWriter;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.name.QName;

class FileRecordOutput {
    private final FileRecord record;
    private final DataOutputStream out;
    private final NamespaceResolver resolver;
    private final ArrayList uuidIndex = new ArrayList();
    private boolean closed;

    public FileRecordOutput(FileRecord record, DataOutputStream out, NamespaceResolver resolver) {
        this.record = record;
        this.out = out;
        this.resolver = resolver;
    }

    public void writeByte(int n) throws IOException {
        this.checkOpen();
        this.out.writeByte(n);
    }

    public void writeChar(char c) throws IOException {
        this.checkOpen();
        this.out.writeChar(c);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.checkOpen();
        this.out.writeBoolean(b);
    }

    public void writeInt(int n) throws IOException {
        this.checkOpen();
        this.out.writeInt(n);
    }

    public void writeString(String s) throws IOException {
        this.checkOpen();
        if (s == null) {
            this.out.writeBoolean(true);
        } else {
            this.out.writeBoolean(false);
            this.out.writeUTF(s);
        }
    }

    public void writeQName(QName name) throws IOException, NoPrefixDeclaredException {
        this.checkOpen();
        this.writeString(NameFormat.format((QName)name, (NamespaceResolver)this.resolver));
    }

    public void writePathElement(Path.PathElement element) throws IOException, NoPrefixDeclaredException {
        this.checkOpen();
        this.writeQName(element.getName());
        this.writeInt(element.getIndex());
    }

    public void writePath(Path path) throws IOException, NoPrefixDeclaredException {
        this.checkOpen();
        this.writeString(PathFormat.format((Path)path, (NamespaceResolver)this.resolver));
    }

    public void writeNodeId(NodeId nodeId) throws IOException {
        this.checkOpen();
        if (nodeId == null) {
            this.writeByte(73);
            this.writeInt(-1);
        } else {
            int index = this.getOrCreateIndex(nodeId);
            if (index != -1) {
                this.writeByte(73);
                this.writeInt(index);
            } else {
                this.writeByte(76);
                this.out.write(nodeId.getUUID().getRawBytes());
            }
        }
    }

    public void writePropertyId(PropertyId propertyId) throws IOException, NoPrefixDeclaredException {
        this.checkOpen();
        this.writeNodeId(propertyId.getParentId());
        this.writeQName(propertyId.getName());
    }

    public void writeNodeTypeDef(NodeTypeDef ntd) throws IOException {
        this.checkOpen();
        StringWriter sw = new StringWriter();
        CompactNodeTypeDefWriter writer = new CompactNodeTypeDefWriter(sw, this.resolver, true);
        writer.write(ntd);
        writer.close();
        this.writeString(sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.checkOpen();
        try {
            this.out.close();
        }
        finally {
            this.closed = true;
            this.record.closed();
        }
    }

    private int getOrCreateIndex(NodeId nodeId) {
        int index = this.uuidIndex.indexOf(nodeId);
        if (index == -1) {
            this.uuidIndex.add(nodeId);
        }
        return index;
    }

    private void checkOpen() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Output closed.");
        }
    }
}

