/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.name.QName;

public class ExactQueryNode
extends QueryNode {
    private final QName property;
    private final QName value;

    public ExactQueryNode(QueryNode parent, QName property, QName value) {
        super(parent);
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.property = property;
        this.value = value;
    }

    public Object accept(QueryNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int getType() {
        return 5;
    }

    public QName getPropertyName() {
        return this.property;
    }

    public QName getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExactQueryNode) {
            ExactQueryNode other = (ExactQueryNode)obj;
            return (this.value == null ? other.value == null : this.value.equals((Object)other.value)) && (this.property == null ? other.property == null : this.property.equals((Object)other.property));
        }
        return false;
    }
}

