/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class MatchAllScorer
extends Scorer {
    private int nextDoc = -1;
    private IndexReader reader;
    private String field;
    private BitSet docFilter;
    private final Explanation matchExpl;

    MatchAllScorer(IndexReader reader, String field) throws IOException {
        super(Similarity.getDefault());
        this.reader = reader;
        this.field = field;
        this.matchExpl = new Explanation(Similarity.getDefault().idf(reader.maxDoc(), reader.maxDoc()), "matchAll");
        this.calculateDocFilter();
    }

    public void score(HitCollector hc) throws IOException {
        while (this.next()) {
            hc.collect(this.doc(), this.score());
        }
    }

    public boolean next() throws IOException {
        this.nextDoc = this.docFilter.nextSetBit(this.nextDoc + 1);
        return this.nextDoc > -1;
    }

    public int doc() {
        return this.nextDoc;
    }

    public float score() throws IOException {
        return 1.0f;
    }

    public boolean skipTo(int target) throws IOException {
        this.nextDoc = target - 1;
        return this.next();
    }

    public Explanation explain(int doc) {
        return this.matchExpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateDocFilter() throws IOException {
        this.docFilter = new BitSet(this.reader.maxDoc());
        TermEnum terms = this.reader.terms(new Term(FieldNames.PROPERTIES, this.field));
        try {
            TermDocs docs = this.reader.termDocs();
            try {
                while (terms.term() != null && terms.term().field() == FieldNames.PROPERTIES && terms.term().text().startsWith(this.field)) {
                    docs.seek(terms);
                    while (docs.next()) {
                        this.docFilter.set(docs.doc());
                    }
                    terms.next();
                }
            }
            finally {
                docs.close();
            }
        }
        finally {
            terms.close();
        }
    }
}

