/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.JavaToWSDL;
import org.jboss.ws.tools.JavaWriter;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.WSDLToJava;
import org.jboss.ws.tools.WSDotXMLCreator;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.client.ServiceCreator;
import org.jboss.ws.tools.mapping.MappingFileGenerator;
import org.jboss.ws.utils.IOUtils;
import org.jboss.ws.utils.JavaUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsHelper {
    private static Logger log = Logger.getLogger(ToolsHelper.class);

    public void handleJavaToWSDLGeneration(Configuration config, String outDir) throws IOException {
        Configuration.JavaToWSDLConfig j2wc = config.getJavaToWSDLConfig(false);
        JavaToWSDL jwsdl = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
        jwsdl.setServiceName(j2wc.serviceName);
        jwsdl.setTargetNamespace(j2wc.targetNamespace);
        jwsdl.setTypeNamespace(j2wc.typeNamespace);
        jwsdl.setOperationMap(j2wc.operations);
        if ("document".equals(j2wc.wsdlStyle)) {
            jwsdl.setStyle(Style.DOCUMENT);
        } else if ("rpc".equals(j2wc.wsdlStyle)) {
            jwsdl.setStyle(Style.RPC);
        } else {
            throw new WSException("Unrecognized Style:" + j2wc.wsdlStyle);
        }
        if ("wrapped".equals(j2wc.parameterStyle)) {
            jwsdl.setParameterStyle(ParameterStyle.WRAPPED);
        } else if ("bare".equals(j2wc.parameterStyle)) {
            jwsdl.setParameterStyle(ParameterStyle.BARE);
        } else {
            throw new WSException("Unrecognized Parameter Style:" + j2wc.parameterStyle);
        }
        Class endpointClass = this.loadClass(j2wc.endpointName);
        if (endpointClass == null) {
            throw new WSException("Endpoint " + j2wc.endpointName + " cannot be loaded");
        }
        Configuration.GlobalConfig gcfg = config.getGlobalConfig(false);
        if (gcfg != null && gcfg.packageNamespaceMap != null) {
            jwsdl.setPackageNamespaceMap(gcfg.packageNamespaceMap);
        }
        WSDLDefinitions wsdl = jwsdl.generate(endpointClass);
        this.createDir(outDir + "/wsdl");
        String wsdlPath = outDir + "/wsdl/" + j2wc.serviceName + ".wsdl";
        Writer fw = IOUtils.getCharsetFileWriter(new File(wsdlPath), "UTF-8");
        wsdl.write(fw, "UTF-8");
        fw.close();
        if (j2wc.mappingFileNeeded) {
            UnifiedMetaData unifiedMetaData = jwsdl.getUnifiedMetaData();
            JavaWsdlMapping mapping = jwsdl.getJavaWsdlMapping();
            this.createWrapperTypes(j2wc, outDir, unifiedMetaData, mapping, endpointClass);
            Writer writer = IOUtils.getCharsetFileWriter(new File(outDir + "/" + j2wc.mappingFileName), "UTF-8");
            writer.write("<?xml version='1.0' encoding='UTF-8'?>");
            writer.write(DOMWriter.printNode((Node)DOMUtils.parse((String)mapping.serialize()), (boolean)true));
            writer.close();
        }
        if (j2wc.wsxmlFileNeeded) {
            WSDotXMLCreator wscr = new WSDotXMLCreator();
            wscr.setTargetNamespace(j2wc.targetNamespace);
            wscr.setSeiName(j2wc.endpointName);
            wscr.setServiceName(j2wc.serviceName);
            WSDLService wsdlService = wsdl.getService(new NCName(j2wc.serviceName));
            String portName = wsdlService.getEndpoints()[0].getName().toString();
            wscr.setPortName(portName);
            if (j2wc.servletLink != null) {
                wscr.setMappingFile("WEB-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("WEB-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setServletLink(j2wc.servletLink);
            } else {
                wscr.setMappingFile("META-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("META-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setEjbLink(j2wc.ejbLink);
            }
            wscr.generateWSXMLDescriptor(new File(outDir + "/webservices.xml"));
        }
    }

    private void createWrapperTypes(Configuration.JavaToWSDLConfig j2wc, String outDir, UnifiedMetaData unifiedMetaData, JavaWsdlMapping mapping, Class endpointClass) throws IOException {
        ServiceMetaData service;
        Map<QName, JavaXmlTypeMapping> index = this.indexMappingTypes(mapping);
        EndpointMetaData endpoint = null;
        Iterator<ServiceMetaData> i$ = unifiedMetaData.getServices().iterator();
        while (i$.hasNext() && (endpoint = (service = i$.next()).getEndpointByServiceEndpointInterface(j2wc.endpointName)) == null) {
        }
        if (endpoint == null) {
            throw new WSException("Could not find endpoint in metadata: " + j2wc.endpointName);
        }
        if (endpoint.getStyle() != Style.DOCUMENT || endpoint.getParameterStyle() != ParameterStyle.WRAPPED) {
            return;
        }
        String packageName = endpointClass.getPackage().getName();
        ClassLoader classLoader = unifiedMetaData.getClassLoader();
        for (OperationMetaData operation : endpoint.getOperations()) {
            for (ParameterMetaData parameter : operation.getParameters()) {
                String name = endpointClass.getSimpleName() + "_" + operation.getXmlName().getLocalPart() + "_RequestStruct";
                this.createWrapperType(parameter, name, packageName, index, classLoader, outDir);
            }
            ParameterMetaData returnParameter = operation.getReturnParameter();
            if (returnParameter == null) continue;
            String name = endpointClass.getSimpleName() + "_" + operation.getXmlName().getLocalPart() + "_ResponseStruct";
            this.createWrapperType(returnParameter, name, packageName, index, classLoader, outDir);
        }
        mapping.removePackageMappingsByPackageType("org.jboss.ws.jaxrpc");
    }

    private void createWrapperType(ParameterMetaData parameter, String name, String packageName, Map<QName, JavaXmlTypeMapping> mappingIndex, ClassLoader classLoader, String outDir) throws IOException {
        List<String> wrappedVariables = parameter.getWrappedVariables();
        if (wrappedVariables == null) {
            return;
        }
        ArrayList<XSDTypeToJava.VAR> vars = new ArrayList<XSDTypeToJava.VAR>();
        List<String> wrappedTypes = parameter.getWrappedTypes();
        for (int i = 0; i < wrappedVariables.size(); ++i) {
            String typeName = JavaUtils.convertJVMNameToSourceName(wrappedTypes.get(i), classLoader);
            vars.add(new XSDTypeToJava.VAR(wrappedVariables.get(i), typeName, false));
        }
        JavaWriter writer = new JavaWriter();
        writer.createJavaFile(new File(outDir), name + ".java", packageName, vars, null, null, false, null);
        JavaXmlTypeMapping type = mappingIndex.get(parameter.getXmlType());
        if (type == null) {
            throw new WSException("JAX-RPC mapping metadata is missing a wrapper type: " + parameter.getXmlType());
        }
        type.setJavaType(packageName + "." + name);
    }

    private Map<QName, JavaXmlTypeMapping> indexMappingTypes(JavaWsdlMapping mapping) {
        HashMap<QName, JavaXmlTypeMapping> index = new HashMap<QName, JavaXmlTypeMapping>();
        for (JavaXmlTypeMapping type : mapping.getJavaXmlTypeMappings()) {
            QName qname = type.getRootTypeQName();
            if (qname == null) continue;
            index.put(qname, type);
        }
        return index;
    }

    public void handleWSDLToJavaGeneration(Configuration config, String outDir) {
        Configuration.WSDLToJavaConfig w2jc = config.getWSDLToJavaConfig(false);
        Configuration.GlobalConfig glc = config.getGlobalConfig(false);
        WSDLToJava wsdlToJava = new WSDLToJava();
        wsdlToJava.setTypeMapping(new LiteralTypeMapping());
        WSDLDefinitions wsdl = null;
        try {
            File wsdlFile;
            URL wsdlURL = null;
            try {
                wsdlURL = new URL(w2jc.wsdlLocation);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (wsdlURL == null && (wsdlFile = new File(w2jc.wsdlLocation)).exists()) {
                wsdlURL = wsdlFile.toURL();
            }
            if (wsdlURL == null) {
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                wsdlURL = ctxLoader.getResource(w2jc.wsdlLocation);
            }
            if (wsdlURL == null) {
                throw new IllegalArgumentException("Cannot load wsdl: " + w2jc.wsdlLocation);
            }
            wsdl = wsdlToJava.convertWSDL2Java(wsdlURL);
            if (glc != null) {
                wsdlToJava.setPackageNamespaceMap(glc.packageNamespaceMap);
            }
            wsdlToJava.generateSEI(wsdl, new File(outDir));
            this.generateServiceFile(this.getPackageName(wsdl, glc), wsdl, outDir);
            if (w2jc.mappingFileNeeded) {
                MappingFileGenerator mgf = new MappingFileGenerator(wsdl, new LiteralTypeMapping());
                mgf.setPackageName(this.getPackageName(wsdl, glc));
                mgf.setServiceName(wsdl.getServices()[0].getName().toString());
                JavaWsdlMapping jwm = mgf.generate();
                Writer writer = IOUtils.getCharsetFileWriter(new File(outDir + "/" + w2jc.mappingFileName), "UTF-8");
                writer.write("<?xml version='1.0' encoding='UTF-8'?>");
                writer.write(DOMWriter.printNode((Node)DOMUtils.parse((String)jwm.serialize()), (boolean)true));
                writer.close();
            }
        }
        catch (MalformedURLException e) {
            throw new WSException(e);
        }
        catch (WSDLException e) {
            throw new WSException(e);
        }
        catch (IOException e) {
            throw new WSException(e);
        }
    }

    private Class loadClass(String cls) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(cls);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Cannot load endpoint:" + e.getLocalizedMessage()));
        }
        return clazz;
    }

    private void generateServiceFile(String packageName, WSDLDefinitions wsdl, String location) throws IOException {
        ServiceCreator sc = new ServiceCreator();
        sc.setPackageName(packageName);
        sc.setDirLocation(new File(location));
        sc.setWsdl(wsdl);
        sc.createServiceDescriptor();
    }

    private String getPackageName(WSDLDefinitions wsdl, Configuration.GlobalConfig glc) {
        String targetNamespace = wsdl.getTargetNamespace();
        if (glc != null && glc.packageNamespaceMap != null) {
            Map<String, String> map = glc.packageNamespaceMap;
            for (String pkg : map.keySet()) {
                String ns = map.get(pkg);
                if (!ns.equals(targetNamespace)) continue;
                return pkg;
            }
        }
        return ToolsUtils.getJavaPackageName(wsdl.getTargetNamespace());
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

