/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.sadun.util.polling.BaseDirectoryEvent;
import org.sadun.util.polling.DirectoryPoller;

public class FileFoundEvent
extends BaseDirectoryEvent {
    private File file;
    private static DateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

    FileFoundEvent(DirectoryPoller poller, File file) {
        super(poller, file.getParentFile());
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return "File found in: " + this.getDirectory().getAbsolutePath() + ": " + this.file.getName() + ", size: " + (int)(this.file.length() / 1024L) + "K ,mod. " + df.format(new Date(this.file.lastModified()));
    }
}

