/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import java.io.File;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.sadun.util.polling.BasePollerEvent;
import org.sadun.util.polling.CycleEndEvent;
import org.sadun.util.polling.CycleEndJMXNotification;
import org.sadun.util.polling.CycleStartEvent;
import org.sadun.util.polling.CycleStartJMXNotification;
import org.sadun.util.polling.DirectoryLookupEndEvent;
import org.sadun.util.polling.DirectoryLookupEndJMXNotification;
import org.sadun.util.polling.DirectoryLookupStartEvent;
import org.sadun.util.polling.DirectoryLookupStartJMXNotification;
import org.sadun.util.polling.ExceptionDeletingTargetFileJMXNotification;
import org.sadun.util.polling.ExceptionMovingFileJMXNotification;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileFoundJMXNotification;
import org.sadun.util.polling.FileMovedEvent;
import org.sadun.util.polling.FileMovedJMXNotification;
import org.sadun.util.polling.FileSetFoundEvent;
import org.sadun.util.polling.FileSetFoundJMXNotification;
import org.sadun.util.polling.PollManager;
import org.sadun.util.polling.SequenceNumberGenerator;

class JMXNotificationsPollManager
implements PollManager {
    private NotificationBroadcasterSupport ns = new NotificationBroadcasterSupport();
    private static final boolean debug = false;
    private SequenceNumberGenerator sqg;
    private ObjectName pollerName;

    public JMXNotificationsPollManager(ObjectName pollerName, SequenceNumberGenerator sqg) {
        this.pollerName = pollerName;
        this.sqg = sqg;
    }

    public void cycleEnded(CycleEndEvent evt) {
        this.ns.sendNotification(new CycleEndJMXNotification(this.pollerName, this.sqg, evt));
    }

    public void cycleStarted(CycleStartEvent evt) {
        this.ns.sendNotification(new CycleStartJMXNotification(this.pollerName, this.sqg, evt));
    }

    public void directoryLookupEnded(DirectoryLookupEndEvent evt) {
        this.ns.sendNotification(new DirectoryLookupEndJMXNotification(this.pollerName, this.sqg, evt));
    }

    public void directoryLookupStarted(DirectoryLookupStartEvent evt) {
        this.ns.sendNotification(new DirectoryLookupStartJMXNotification(this.pollerName, this.sqg, evt));
    }

    public void exceptionDeletingTargetFile(File target) {
        this.ns.sendNotification(new ExceptionDeletingTargetFileJMXNotification(this.pollerName, this.sqg, target));
    }

    public void exceptionMovingFile(File file, File dest) {
        this.ns.sendNotification(new ExceptionMovingFileJMXNotification(this.pollerName, this.sqg, file, dest));
    }

    public void fileFound(FileFoundEvent evt) {
        this.ns.sendNotification(new FileFoundJMXNotification(this.pollerName, this.sqg, evt));
    }

    public void fileMoved(FileMovedEvent evt) {
        this.ns.sendNotification(new FileMovedJMXNotification(this.pollerName, this.sqg, evt));
    }

    public void fileSetFound(FileSetFoundEvent evt) {
        this.ns.sendNotification(new FileSetFoundJMXNotification(this.pollerName, this.sqg, evt));
    }

    public void addListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.ns.addNotificationListener(listener, filter, handback);
    }

    public void removeListener(NotificationListener listener) throws ListenerNotFoundException {
        this.ns.removeNotificationListener(listener);
    }

    private static void logEvent(BasePollerEvent evt) {
        System.out.println((Object)evt);
    }

    private static void logException(File target, File dest) {
        System.out.println("Exception " + (dest != null ? "moving" : "deleting") + " " + target);
    }

    public String toString() {
        return "An internal pollmanager dispatching JMX notifications corresponding to basic events";
    }
}

